<?php
session_start();
require_once '../../asset/mpdf/vendor/autoload.php';
include("../../php_crud/my_class.php");
$obj = new my_class();
$user_id = $_SESSION['LOGIN_USERID'];
extract($_GET);

$start_date1 = new DateTime($start_date);
$end_date1 = new DateTime($end_date);
$interval = new DateInterval('P1D');
$end_date1->add($interval);

$period = new DatePeriod($start_date1, $interval, $end_date1);
function convert_number2($number){
	if (($number < 0) || ($number > 999999999))
	{
		//throw new Exception("Number is out of range");
		echo "Number range is over!";
	}

	/* Crore */
	$Cn = floor($number/10000000);  
	$number -= $Cn * 10000000;
			
	/* Lacs  */
	$Gn = floor($number / 100000);  
	$number -= $Gn * 100000;
				
	/* Thousands */		
	$kn = floor($number / 1000);     
	$number -= $kn * 1000;
				
	/* Hundreds */		
	$Hn = floor($number / 100);      
	$number -= $Hn * 100;
				
	/* Tens  */
	$Dn = floor($number / 10);      
				
	/* Ones */
	$n   = $number % 10;               
	$res = "";
					
	if($Cn) {
	 $res .= convert_number2($Cn) . " Crore ";
	}			
	if ($Gn){
		$res .= convert_number2($Gn) . " Lakh";
	}
	if ($kn){
		$res .= (empty($res) ? "" : " ") .convert_number2($kn) . " Thousand";
	}
	if ($Hn){
		$res .= (empty($res) ? "" : " ") .convert_number2($Hn) . " Hundred";
	}
				
	$ones = array("", "One", "Two", "Three", "Four", "Five", "Six","Seven","Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen","Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen","Nineteen");
				
	$tens = array("", "", "Twenty", "Thirty", "Fourty","Fifty", "Sixty","Seventy", "Eigthy", "Ninety");
		
	if ($Dn || $n){
		if (!empty($res)){
			$res .= " and ";
		}
		if ($Dn < 2){
			$res .= $ones[$Dn * 10 + $n];
		}else{
			$res .= $tens[$Dn];
			if ($n){
				$res .= "-" . $ones[$n];
			}
		}
	}
	if (empty($res)){
		$res = "zero";
	}
	return $res;
}
$html = "<html><head>

</head>
<style>
	.th_left_bottom_border{
		font-weight: bold; 
		text-align: center;
		border-left: 1px solid; 
		border-bottom: 1px solid; 
	}

	.th_left_right_bottom_border{
		font-weight: bold; 
		text-align: center;
		border-left: 1px solid; 
		border-bottom: 1px solid; 
		border-right: 1px solid;
	}

	.td_left_bottom_border{
		border-left: 1px solid; 
		border-bottom: 1px solid; 
	}

	.td_left_right_bottom_border{
		border-left: 1px solid; 
		border-bottom: 1px solid; 
		border-right: 1px solid;
	}
</style>
<body>";

$html = "
<body>
<div>
<table style='width: 100%; border-collapse: collapse; border: 0px solid black;'>
    <thead>
		<tr>
            <th colspan='3' style='border-bottom: 1px solid black; font-size: 15px; text-align: center;'>
						Surface Water (Real Time)  Missing Day Report For $start_date To $end_date
            </th>
        </tr>
        <tr>
            <td style='text-align: center; font-size: 10px; border: 1px solid black;'>Sl</td>
            <td style='text-align: center; font-size: 10px; border: 1px solid black;'>Date</td>
            <td style='text-align: center; font-size: 10px; border: 1px solid black;'>Penalty Amount</td>
        </tr>
    </thead>
    <tbody>";

$i = 1;
$penalti_fee="2000 Tk";
$total_penalty= 0;
foreach ($period as $key => $value) {

    $html .= "<tr>
        <td style='font-size: 14px; text-align: center; border: 1px solid black;'>".$i."</td>
        <td style='font-size: 14px; text-align: center; border: 1px solid black;'>".$value->format('d-M-y')."</td>
        <td style='font-size: 14px; text-align: right; border: 1px solid black;'>".$penalti_fee."</td>

    </tr>";

    $i++; 
    $total_penalty += $penalti_fee;
}
// $grand_total_in_word = convert_number2($total_penalty);
$html .= "<tr>
    <td colspan='2' style='font-size: 14px; text-align: right; padding-right: 10px; border: 1px solid black; font-weight: bold;'>Total</td>
    <td style='font-size: 14px; text-align: right; border: 1px solid black; font-weight: bold;'>".$total_penalty."Tk</td>
</tr>";
$html .= "</tbody></table>
</div>
</body>
</html>";
//echo $html; exit();
$header = "<div class='site-header'>
		<img src='../../asset/custom/bwdb_swh_banner.png' width='100%' />
	</div>";
$footer='Page: {PAGENO} Of {nb}';
$mpdf = new \Mpdf\Mpdf([ 
	'format' => 'A4-P',
	'margin_left' => 10,
    'margin_right' => 10,
    'margin_top' => 47,
    'margin_bottom' => 15
]);
// echo $html;
// exit();
$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLFooter($footer);
$mpdf->WriteHTML($html);
$mpdf->SetWatermarkImage('http://hims.bwdb.gov.bd/hydrology/images/logo.jpg', 0.3, array(100,100),array(50,120));
$mpdf->showWatermarkImage = true;
$mpdf->Output();
?>