<?php 
	session_start();
    error_reporting(1); //(E_ALL);
    ini_set('display_errors', TRUE);
    ini_set('display_startup_errors', TRUE);
    include("../../asset/theme/css/myfunc.php");
	include("../../php_crud/my_class.php");
	
	require_once('../../asset/vendor/autoload.php');

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

	
    $obj = new my_class();

	extract($_GET);

	$user_id=$_SESSION["user_id"];

	$inv_det_tbl = "HYDROLOGY.REQUEST_DATA_DETAILS@HYDRO10";
	$inv_det_cols = "TO_CHAR(FROM_DATE, 'DD-MON-YYYY') FROM_DATE,TO_CHAR(TO_DATE, 'DD-MON-YYYY') TO_DATE,
	STATION_ID,DATA_TYPE_ID,DURATION_ID,DISTRICT_ID,UPAZILA_ID,FREQUENCY_ID,INVOICE_ID";
	$inv_det_cond = "ID='$det_id'";
	
	$inv_det_info = $obj->View_column_details_By_Cond($inv_det_tbl,$inv_det_cols,$inv_det_cond);
	
	$FROM_DATE = $inv_det_info['FROM_DATE'];
	$TO_DATE = $inv_det_info['TO_DATE'];
	$STATION_IDS = $inv_det_info['STATION_ID'];
	$DATA_TYPE_ID = $inv_det_info['DATA_TYPE_ID']; 
	$FREQUENCY_ID = $inv_det_info['FREQUENCY_ID'];
	$DURATION_ID = $inv_det_info['DURATION_ID'];
	$DISTRICT_NO = $inv_det_info['DISTRICT_ID'];
	$UPZL_CODE = $inv_det_info['UPAZILA_ID'];
	$invoice_no = $inv_det_info['INVOICE_ID'];
	
	$inv_mas_tbl = "HYDROLOGY.REQUEST_DATA_MASTER@HYDRO10";
	$inv_mas_cols = "TO_CHAR(PAYMENT_DATE, 'DD-MON-YYYY') PAYMENT_DATE";
	$inv_mas_cond = "INVOICE_NO='$invoice_no'";
	
	$inv_mas_info = $obj->View_column_details_By_Cond($inv_mas_tbl,$inv_mas_cols,$inv_mas_cond);
	
	$payment_date = $inv_mas_info['PAYMENT_DATE'];
	
	$data_type_tbl = "HYDROLOGY.DATA_TYPE@HYDRO10";
	$data_type_cond = "DID='$DATA_TYPE_ID'";
	
	$data_type_info = $obj->Details_By_Cond($data_type_tbl,$data_type_cond);
	
	$DATA_TYPE = $data_type_info['DATA_TYPE'];
	
	$freq_type_tbl = "HYDROLOGY.FREQUENCY@HYDRO10";
	$freq_type_cond = "FID='$FREQUENCY_ID'";
	
	$freq_type_info = $obj->Details_By_Cond($freq_type_tbl,$freq_type_cond);
	
	$F_NAME = $freq_type_info['F_NAME'];
	$auto_param_id = $freq_type_info['AUTO_PARAM_ID'];
	
	$start_date = date("d-MON-Y", strtotime($FROM_DATE));
	$end_date = date("d-MON-Y", strtotime($TO_DATE));

	$start_month = date("m",strtotime($FROM_DATE));
	$end_month = date("m",strtotime($TO_DATE));
	$start_day = date("d",strtotime($FROM_DATE));
	$end_day = date("d",strtotime($TO_DATE));

	
	$start_date4 = date("Y", strtotime($FROM_DATE));
	$end_date4 = date("Y", strtotime($TO_DATE));
	
	$file_dt_type = str_replace(" ", "_", $DATA_TYPE);
	$filename = 'temp/'.$file_dt_type.$STATION_IDS.$det_id.'.xlsx';
	$dr_filename = $file_dt_type.$STATION_IDS.$det_id.'.xlsx';
	

	
	$objPHPExcel = new Spreadsheet();
	$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
	$drawing->setName('BWDB Logo');
	$drawing->setDescription('BWDB Logo');
	$drawing->setPath('../../asset/custom/bwdb_logo.png'); // put your path and image here
	$objPHPExcel->getActiveSheet()->mergeCells('A1:B6');
	//$objPHPExcel->getActiveSheet()->getStyle('A1:B6')->getAlignment()->setHorizontal('center');
	$drawing->setCoordinates('A1');
	$drawing->setOffsetX(20);
	$drawing->setOffsetY(20);
	$drawing->setWorksheet($objPHPExcel->getActiveSheet());
	
	$drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
	$drawing->setName('BWDB Logo');
	$drawing->setDescription('BWDB Logo');
	$drawing->setPath('../../asset/custom/bwdb_logo.png'); // put your path and image here
	$objPHPExcel->getActiveSheet()->mergeCells('K1:L6');
	//$objPHPExcel->getActiveSheet()->getStyle('K1:L6')->getAlignment()->setHorizontal('center');
	$drawing->setCoordinates('K1');
	$drawing->setOffsetX(20);
	$drawing->setOffsetY(20);
	$drawing->setWorksheet($objPHPExcel->getActiveSheet());
	
	$objPHPExcel->getActiveSheet()->mergeCells('C1:J6');
	$objPHPExcel->getActiveSheet()->getStyle('C1:J6')->getAlignment()->setHorizontal('center');

	$objPHPExcel->setActiveSheetIndex(0)
	->getCell('C1')->setValue("Bangladesh Water Development Board \n Hydroinformatics and Flood Forecasting Circle\n 72-Green Road, Dhaka-1215, Bangladesh\nPhone: +88-02-58151530, +88-02-222230358\nEmail: se.pffc@bwdb.gov.bd\nWeb: www.hydrology.bwdb.gov.bd");

	$objPHPExcel->getActiveSheet()->getStyle('A1:L1')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A2:L2')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A3:L3')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A4:L4')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A5:L5')->getAlignment()->setWrapText(true);
	$objPHPExcel->getActiveSheet()->getStyle('A6:L6')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A7:F7');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A7')->setValue( "Invoice No: ".$invoice_no);
	$objPHPExcel->getActiveSheet()->getStyle('A7:F7')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('G7:L7');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G7')->setValue( "Payment Date: ".$payment_date);
	$objPHPExcel->getActiveSheet()->getStyle('G7:L7')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('A8:C8');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('A8')->setValue( "Data Type: ". $DATA_TYPE);
	$objPHPExcel->getActiveSheet()->getStyle('A8:C8')->getAlignment()->setWrapText(true);
	
	$objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('D8')->setValue( "Frequency Name: ". $F_NAME);
	$objPHPExcel->getActiveSheet()->getStyle('D8:F8')->getAlignment()->setWrapText(true);

	$objPHPExcel->getActiveSheet()->mergeCells('G8:H8');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('G8')->setValue( "Duration: ". $DURATION_ID);
	$objPHPExcel->getActiveSheet()->getStyle('G8:H8')->getAlignment()->setWrapText(true);

	$objPHPExcel->getActiveSheet()->mergeCells('I8:L8');
	$objPHPExcel->setActiveSheetIndex(0)->getCell('I8')->setValue( "From: ". $start_date4." To: ". $end_date4."");
	$objPHPExcel->getActiveSheet()->getStyle('I8:L8')->getAlignment()->setWrapText(true);

	$objPHPExcel->getActiveSheet()->getStyle('A1:L8')->getFont()->setBold(true);

	$x=0;

	$row_no=12;
	if($DATA_TYPE_ID=='2'){
		/*3 Hourly start*/
		if($FREQUENCY_ID=='1'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATA TYPE')
				->setCellValue('C11', 'DATE TIME')
				->setCellValue('D11', 'WL (mMSL)');
				
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.00');

			foreach($obj->manual_water_level_three_hourly($start_date4,$end_date4,$STATION_IDS) as $wl_3_hourly){
				$x++;
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $wl_3_hourly['DATA_TYPE'])
					->setCellValue('C'.$row_no, $wl_3_hourly['DATE_TIME'])
					->setCellValue('D'.$row_no, (float)$wl_3_hourly['WL_MMSL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*3 Hourly end*/
		/*Daily High-Low (Non-Tidal) and (Tidal) start*/
		if($FREQUENCY_ID=='2' || $FREQUENCY_ID=='3'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'Date')
				->setCellValue('C11', 'Daily Max WL (mMSL)')
				->setCellValue('D11', 'Daily Min WL (mMSL)')
				->setCellValue('E11', 'Daily Avg WL (mMSL)');
				
				$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.00');

			foreach($obj->manual_water_level_daily_high_low($start_date4,$end_date4,$STATION_IDS) as $wl_daily_high_low){
				$x++;
					
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $wl_daily_high_low['DATE_TIME'])
					->setCellValue('C'.$row_no, (float)$wl_daily_high_low['DAILY_MAX_WL_MMSL'])
					->setCellValue('D'.$row_no, (float)$wl_daily_high_low['DAILY_MIN_WL_MMSL'])
					->setCellValue('E'.$row_no, (float)$wl_daily_high_low['DAILY_AVG_WL_MMSL']);
					 
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Daily High-Low (Non-Tidal) and (Tidal) end*/
		/*Annunal High-Low (Non Tidal) and (Tidal) start*/
		else if($FREQUENCY_ID=='46' || $FREQUENCY_ID=='4'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'YEAR')
				->setCellValue('C11', 'Year Max Date')
				->setCellValue('D11', 'Year Max WL (mMSL)')
				->setCellValue('E11', 'Year Min Date')
				->setCellValue('F11', 'Year Min WL (mMSL)')
				->setCellValue('G11', 'Year Avg WL (mMSL)');
				
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			
			foreach($obj->manual_water_level_annual_high_low($start_date4,$end_date4,$STATION_IDS) as $wl_annual_high_low){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$wl_annual_high_low['READ_YEAR'])
					->setCellValue('C'.$row_no, $wl_annual_high_low['YEAR_MAX_DATE'])
					->setCellValue('D'.$row_no, (float)$wl_annual_high_low['YEAR_MAX_WL_MMSL'])
					->setCellValue('E'.$row_no, $wl_annual_high_low['YEAR_MIN_DATE'])
					->setCellValue('F'.$row_no, (float)$wl_annual_high_low['YEAR_MIN_WL_MMSL'])
					->setCellValue('G'.$row_no, (float)$wl_annual_high_low['YEAR_AVG_WL_MMSL']);
					 
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*Annunal High-Low (Non Tidal) and (Tidal) end*/
		/*Monthly High-Low (Non Tidal) and (Tidal) start*/
		else if($FREQUENCY_ID=='49' || $FREQUENCY_ID=='50'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'Year')
				->setCellValue('C11', 'Month')
				->setCellValue('D11', 'Monthly Max Date')
				->setCellValue('E11', 'Monthly Max WL (mMSL)')
				->setCellValue('F11', 'Monthly Min Date')
				->setCellValue('G11', 'Monthly Min WL (mMSL)')
				->setCellValue('H11', 'Monthly Avg WL (mMSL)');
				
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H11')->getNumberFormat()->setFormatCode('#,##0.00');
			
			foreach($obj->manual_water_level_monthly_high_low($start_date4,$end_date4,$STATION_IDS) as $wl_monthly_high_low){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$wl_monthly_high_low['SWL_YEAR'])
					->setCellValue('C'.$row_no, (int)$wl_monthly_high_low['SWL_MONTH'])
					->setCellValue('D'.$row_no, $wl_monthly_high_low['MONTHLY_MAX_DATE'])
					->setCellValue('E'.$row_no, (float)$wl_monthly_high_low['MONTHLY_MAX_WL_MMSL'])
					->setCellValue('F'.$row_no, $wl_monthly_high_low['MONTHLY_MIN_DATE'])
					->setCellValue('G'.$row_no, (float)$wl_monthly_high_low['MONTHLY_MIN_WL_MMSL'])
					->setCellValue('H'.$row_no, (float)$wl_monthly_high_low['MONTHLY_AVG_WL_MMSL'] );
					 
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Monthly High-Low (Non Tidal) and (Tidal) end*/
		/*Maximum Flood Level start*/
		else if($FREQUENCY_ID=='54'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'Date')
				->setCellValue('C11', 'Recorded Highest WL (mMSL)');
			
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');

			foreach($obj->manual_water_level_maximum_flood_level($STATION_IDS) as $maximum_flood_level){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $maximum_flood_level['DTE'])
					->setCellValue('C'.$row_no, (float)$maximum_flood_level['YR_MAX_WL_MMSL']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Maximum Flood Level end*/
	}
	else if($DATA_TYPE_ID=='4'){
		/*rainfall daily start*/
		if($FREQUENCY_ID=='15'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE')
				->setCellValue('C11', 'RAIN FALL(mm)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			
			foreach($obj->manual_rainfall_daily($start_date4,$end_date4,$STATION_IDS) as $manual_rainfall_daily){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_rainfall_daily['RF_DATE'])
					->setCellValue('C'.$row_no, (float)$manual_rainfall_daily['RAIN_FALL']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*rainfall daily end*/
		/*rainfall monthly start*/
		else if($FREQUENCY_ID=='47'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'YEAR')
				->setCellValue('C11', 'JAN')
				->setCellValue('D11', 'FEB')
				->setCellValue('E11', 'MAR')
				->setCellValue('F11', 'APR')
				->setCellValue('G11', 'MAY')
				->setCellValue('H11', 'JUN')
				->setCellValue('I11', 'JUL')
				->setCellValue('J11', 'AUG')
				->setCellValue('K11', 'SEP')
				->setCellValue('L11', 'OCT')
				->setCellValue('M11', 'NOV')
				->setCellValue('N11', 'DEC')
				->setCellValue('O11', 'YEAR TOTAL');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('M11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('N11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('O11')->getNumberFormat()->setFormatCode('#,##0.00');
			
			foreach($obj->manual_rainfall_monthly($start_date4,$end_date4,$STATION_IDS) as $manual_rainfall_monthly){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$manual_rainfall_monthly['YEAR'])
					->setCellValue('C'.$row_no, (float)$manual_rainfall_monthly['JAN'])
					->setCellValue('D'.$row_no, (float)$manual_rainfall_monthly['FEB'])
					->setCellValue('E'.$row_no, (float)$manual_rainfall_monthly['MAR'])
					->setCellValue('F'.$row_no, (float)$manual_rainfall_monthly['APR'])
					->setCellValue('G'.$row_no, (float)$manual_rainfall_monthly['MAY'])
					->setCellValue('H'.$row_no, (float)$manual_rainfall_monthly['JUN'])
					->setCellValue('I'.$row_no, (float)$manual_rainfall_monthly['JUL'])
					->setCellValue('J'.$row_no, (float)$manual_rainfall_monthly['AUG'])
					->setCellValue('K'.$row_no, (float)$manual_rainfall_monthly['SEP'])
					->setCellValue('L'.$row_no, (float)$manual_rainfall_monthly['OCT'])
					->setCellValue('M'.$row_no, (float)$manual_rainfall_monthly['NOV'])
					->setCellValue('N'.$row_no, (float)$manual_rainfall_monthly['DEC'])
					->setCellValue('O'.$row_no, (float)$manual_rainfall_monthly['YR_RF_TOTAL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('O'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*rainfall monthly end*/
		/*rainfall annual start*/
		else if($FREQUENCY_ID=='18'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'YEAR')
				->setCellValue('C11', 'TOTAL RAIN FALL(mm)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			
			foreach($obj->manual_rainfall_annual($start_date4,$end_date4,$STATION_IDS) as $manual_rainfall_annual){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$manual_rainfall_annual['YEAR'])
					->setCellValue('C'.$row_no, (float)$manual_rainfall_annual['RAINFALL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*rainfall annual end*/
	}
	else if($DATA_TYPE_ID=='3'){
		/*evaporation data start*/
		if($FREQUENCY_ID=='45'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'STATION ID')
				->setCellValue('E10', 'STATION')
				->setCellValue('F10', 'DATE')
				->setCellValue('G10', 'EVAPORATION(mm)')
				->setCellValue('H10', 'LATITUDE')
				->setCellValue('I10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('F10')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00000');
			foreach($obj->manual_evaporation_data($start_date4,$end_date4,$STATION_IDS) as $manual_evaporation_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_evaporation_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_evaporation_data['UPZL_NAME'])
					->setCellValue('D'.$row_no, $manual_evaporation_data['STATION_ID'])
					->setCellValue('E'.$row_no, $manual_evaporation_data['STATION_NAME'])
					->setCellValue('F'.$row_no, $manual_evaporation_data['DATETIME'])
					->setCellValue('G'.$row_no, (float)$manual_evaporation_data['EVAPORATION'])
					->setCellValue('H'.$row_no, round($row['LATITUDE'],5))
					->setCellValue('I'.$row_no, round($row['LONGITUDE'],5));
				
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*evaporation data end*/
	}
	else if($DATA_TYPE_ID=='5'){
		/*Observed Discharge start*/
		if($FREQUENCY_ID=='21'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'Date')
				->setCellValue('C11', 'Water_Level(mMSL)')
				->setCellValue('D11', 'Discharge(m)3/s')
				->setCellValue('E11', 'Cross_Sec_Area(m)2')
				->setCellValue('F11', 'Max_Depth(m)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00000');
			
			$x=0;
			foreach($obj->manual_obs_discharge($start_date4,$end_date4,$STATION_IDS) as $manual_obs_discharge){
				$x++;
				$tidal_status="";
				if($manual_obs_discharge['TIDAL_STS']=='T'){
					$tidal_status="Tidal";
				}
				else if($manual_obs_discharge['TIDAL_STS']=='NT'){
					$tidal_status="Non-Tidal";
				}
				else{
					$tidal_status="-";
				}
					
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_obs_discharge['READ_DATE'])
					->setCellValue('C'.$row_no, (float)$manual_obs_discharge['WATER_LEVEL_MMSL'])
					->setCellValue('D'.$row_no, (float)$manual_obs_discharge['DISCHARGE_M_3_S'])
					->setCellValue('E'.$row_no, (float)$manual_obs_discharge['CROSS_SEC_AREA_M_2'])
					->setCellValue('F'.$row_no, (float)$manual_obs_discharge['MAX_DEPTH_M']);
					 
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Observed Discharge end*/
		/*Monthly Discharge start*/
		else if($FREQUENCY_ID=='53'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION NAME')
				->setCellValue('G10', 'STATION TYPE')
				->setCellValue('H10', 'YEAR')
				->setCellValue('I10', 'MONTH')
				->setCellValue('J10', 'MONTHLY MAX DISCHARGE (m)3/s')
				->setCellValue('K10', 'MONTHLY MIN DISCHARGE (m)3/s')
				->setCellValue('L10', 'MONTHLY AVG DISCHARGE (m)3/s')
				->setCellValue('M10', 'LATITUDE')
				->setCellValue('N10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('##');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('N10')->getNumberFormat()->setFormatCode('#,##0.00000');
			
			foreach($obj->manual_monthly_discharge($start_date4,$end_date4,$STATION_IDS) as $manual_monthly_discharge){
				$x++;
				$tidal_status="";
				if($manual_monthly_discharge['TIDAL_STS']=='T'){
					$tidal_status="Tidal";
				}
				else if($manual_monthly_discharge['TIDAL_STS']=='NT'){
					$tidal_status="Non-Tidal";
				}
				else{
					$tidal_status="-";
				}
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_monthly_discharge['DISTRICT'])
					->setCellValue('C'.$row_no, $manual_monthly_discharge['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_monthly_discharge['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_monthly_discharge['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_monthly_discharge['STATION_NAME'])
					->setCellValue('G'.$row_no, $tidal_status)
					->setCellValue('H'.$row_no, (int)$manual_monthly_discharge['YEAR'])
					->setCellValue('I'.$row_no, (int)$manual_monthly_discharge['MONTH'])
					->setCellValue('J'.$row_no, (float)$manual_monthly_discharge['DISCHARGE_MX3S'])
					->setCellValue('K'.$row_no, (float)$manual_monthly_discharge['DISCHARGE_MN3S'])
					->setCellValue('L'.$row_no, (float)$manual_monthly_discharge['DISCHARGE_MV3S'])
					->setCellValue('M'.$row_no, round($manual_monthly_discharge['LATITUDE'],5))
					->setCellValue('N'.$row_no, round($manual_monthly_discharge['LONGITUDE'],5));
					 
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('##');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Monthly Discharge end*/
		/*Annual Discharge Highest, Lowest and Mean start*/
		else if($FREQUENCY_ID=='44'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'RIVER')
				->setCellValue('D10', 'STATION ID')
				->setCellValue('E10', 'STATION NAME')
				->setCellValue('F10', 'YEAR')
				->setCellValue('G10', 'MAX DISCHARGE(m)3/s')
				->setCellValue('H10', 'MIN DISCHARGE(m)3/s')
				->setCellValue('I10', 'AVG DISCHARGE(m)3/s')
				->setCellValue('J10', 'LATITUDE')
				->setCellValue('K10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('F10')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00000');
			
			foreach($obj->manual_discharge_annual_hlm($start_date4,$end_date4,$STATION_IDS) as $manual_discharge_annual_hlm){
				$x++;
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_discharge_annual_hlm['DISTRICT'])
					->setCellValue('C'.$row_no, $manual_discharge_annual_hlm['RIVER_NAME'])
					->setCellValue('D'.$row_no, $manual_discharge_annual_hlm['STATION_ID'])
					->setCellValue('E'.$row_no, $manual_discharge_annual_hlm['STATION_NAME'])
					->setCellValue('F'.$row_no, (int)$manual_discharge_annual_hlm['YEAR'])
					->setCellValue('G'.$row_no, (float)$manual_discharge_annual_hlm['MAX_DISCHARGE'])
					->setCellValue('H'.$row_no, (float)$manual_discharge_annual_hlm['MIN_DISCHARGE'])
					->setCellValue('I'.$row_no, (float)$manual_discharge_annual_hlm['AVG_DISCHARGE'])
					->setCellValue('J'.$row_no, round($manual_discharge_annual_hlm['LATITUDE'],5))
					->setCellValue('K'.$row_no, round($manual_discharge_annual_hlm['LONGITUDE'],5));
					 
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
					
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Annual Discharge Highest, Lowest and Mean end*/
		/*Tidal Discharge start*/
		else if($FREQUENCY_ID=='52'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION NAME')
				->setCellValue('G10', 'DATE')
				->setCellValue('H10', 'WATER LEVEL(m)')
				->setCellValue('I10', 'DISCHARGE(m)3/s')
				->setCellValue('J10', 'LATITUDE')
				->setCellValue('K10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00000');

			foreach($obj->manual_tidal_discharge($start_date4,$end_date4,$STATION_IDS) as $manual_tidal_discharge){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_tidal_discharge['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_tidal_discharge['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_tidal_discharge['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_tidal_discharge['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_tidal_discharge['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_tidal_discharge['DATETIME'])
					->setCellValue('H'.$row_no, (float)$manual_tidal_discharge['WATERLEVEL'])					
					->setCellValue('I'.$row_no, (float)$manual_tidal_discharge['DISCHARGE_M3S'])
					->setCellValue('J'.$row_no, round($manual_tidal_discharge['LATITUDE'],5))
					->setCellValue('K'.$row_no, round($manual_tidal_discharge['LONGITUDE'],5));
					 
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Tidal Discharge end*/
		/*MDD start*/
		else if($FREQUENCY_ID=='57'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION NAME')
				->setCellValue('G10', 'DATETIME')
				->setCellValue('H10', 'WATER LEVEL(m)')
				->setCellValue('I10', 'MDD(m)3/s')
				->setCellValue('J10', 'LATITUDE')
				->setCellValue('K10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('K10'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
			
			foreach($obj->manual_mdd_data($start_date4,$end_date4,$STATION_IDS) as $manual_mdd_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_mdd_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_mdd_data['UZ_NAME'])
					->setCellValue('D'.$row_no, $manual_mdd_data['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_mdd_data['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_mdd_data['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_mdd_data['DATETIME'])
					->setCellValue('H'.$row_no, (float)$manual_mdd_data['WL_M'])
					->setCellValue('I'.$row_no, (float)$manual_mdd_data['MDD_M_3_S'])
					->setCellValue('J'.$row_no, round($manual_mdd_data['LATITUDE'],5))
					->setCellValue('K'.$row_no, round($manual_mdd_data['LONGITUDE'],5));
					
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*MDD end*/
	}
	else if($DATA_TYPE_ID=='6'){
		/*sediment weekly/fortnightly/monthly start*/
		if($FREQUENCY_ID=='28'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION')
				->setCellValue('G10', 'DATE')
				->setCellValue('H10', 'Coarse Suspendent Sediment (KG/sec)')
				->setCellValue('I10', 'Bulk Suspendent Sediment (kg/sec)')
				->setCellValue('J10', 'Bulk Suspendent Cons (ppm) ')
				->setCellValue('K10', 'Total Sediment(kg/sec)')
				->setCellValue('L10', 'LATITUDE')
				->setCellValue('M10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_sediment_wfm($start_date4,$end_date4,$STATION_IDS) as $manual_sediment_wfm){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_sediment_wfm['DISTRICT'])
					->setCellValue('C'.$row_no, $manual_sediment_wfm['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_sediment_wfm['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_sediment_wfm['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_sediment_wfm['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_sediment_wfm['DATETIME'])
					->setCellValue('H'.$row_no, (float)$manual_sediment_wfm['SAND_KGS'])
					->setCellValue('I'.$row_no, (float)$manual_sediment_wfm['FINE_KGS'])
					->setCellValue('J'.$row_no, (float)$manual_sediment_wfm['MAXSANDCONCPPM'])
					->setCellValue('K'.$row_no, (float)$manual_sediment_wfm['SEDCOMBPPM'])
					->setCellValue('L'.$row_no, round($manual_sediment_wfm['LATITUDE'],5))
					->setCellValue('M'.$row_no, round($manual_sediment_wfm['LONGITUDE'],5));
					
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*sediment weekly/fortnightly/monthly end*/
	}
	else if($DATA_TYPE_ID=='7'){
		/*salinity daily data start*/
		if($FREQUENCY_ID=='29'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION')
				->setCellValue('G10', 'DATE')
				->setCellValue('H10', 'EC HIGHTIDE micromho/cm')
				->setCellValue('I10', 'EC LOWTIDE micromho/cm')
				->setCellValue('J10', 'TDS HIGHTIDE(PPM)')
				->setCellValue('K10', 'TDS LOWTIDE(PPM)')
				->setCellValue('L10', 'LATITUDE')
				->setCellValue('M10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_salinity_daily($start_date4,$end_date4,$STATION_IDS) as $manual_salinity_daily){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_salinity_daily['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_salinity_daily['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_salinity_daily['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_salinity_daily['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_salinity_daily['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_salinity_daily['DATETIME'])
					->setCellValue('H'.$row_no, (int)$manual_salinity_daily['EC_HIGHTIDE'])
					->setCellValue('I'.$row_no, (int)$manual_salinity_daily['EC_LOWTIDE'])
					->setCellValue('J'.$row_no, (int)$manual_salinity_daily['CHLORIDEPPM_HIGHTIDE'])
					->setCellValue('K'.$row_no, (int)$manual_salinity_daily['CHLORIDEPPM_LOWTIDE'])
					->setCellValue('L'.$row_no, round($manual_salinity_daily['LATITUDE'],5))
					->setCellValue('M'.$row_no, round($manual_salinity_daily['LONGITUDE'],5));
					
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*salinity daily data end*/
	}
	else if($DATA_TYPE_ID=='8'){
		/*cross section data start*/
		if($FREQUENCY_ID=='30'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'RIVER')
				->setCellValue('D10', 'STATION ID')
				->setCellValue('E10', 'DATE')
				->setCellValue('F10', 'DISTANCE(m)')
				->setCellValue('G10', 'RL(m)')
				->setCellValue('H10', 'L_LATITUDE')
				->setCellValue('I10', 'L_LONGITUDE')
				->setCellValue('J10', 'R_LATITUDE')
				->setCellValue('K10', 'R_LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('E10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('F10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_cross_section_data($start_date4,$end_date4,$STATION_IDS) as $manual_cross_section_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_cross_section_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_cross_section_data['RIVER_NAME'])
					->setCellValue('D'.$row_no, $manual_cross_section_data['STATION_ID'])
					->setCellValue('E'.$row_no, $manual_cross_section_data['DATETIME'])
					->setCellValue('F'.$row_no, (float)$manual_cross_section_data['DISTANCE'])
					->setCellValue('G'.$row_no, (float)$manual_cross_section_data['RL'])
					->setCellValue('H'.$row_no, round($manual_cross_section_data['L_LATITUDE'],5))
					->setCellValue('I'.$row_no, round($manual_cross_section_data['L_LONGITUDE'],5))
					->setCellValue('J'.$row_no, round($manual_cross_section_data['R_LATITUDE'],5))
					->setCellValue('K'.$row_no, round($manual_cross_section_data['R_LONGITUDE'],5));

					
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	

				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*cross section data end*/
	}
	else if($DATA_TYPE_ID=='9'){
		/*surface water quality data start*/
		if($FREQUENCY_ID=='55'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION')
				->setCellValue('G10', 'DATETIME')
				->setCellValue('H10', 'WATER LEVEL(m)')
				->setCellValue('I10', 'BP')
				->setCellValue('J10', 'TEMP(C)')
				->setCellValue('K10', 'PH(m)')
				->setCellValue('L10', 'DO')
				->setCellValue('M10', 'SALINITY(PPT)')
				->setCellValue('N10', 'TDS(Mg/L)')
				->setCellValue('O10', 'EC(MICROS)/CM')
				->setCellValue('P10', 'TRANSPARENCY')
				->setCellValue('Q10', 'FE(Mg/L)')
				->setCellValue('R10', 'CI(Mg/L)')
				->setCellValue('S10', 'LATITUDE')
				->setCellValue('T10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('N10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('O10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('P10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('Q10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('R10')->getNumberFormat()->setFormatCode('#,##0.00');	
			$objPHPExcel->getActiveSheet()->getStyle('S10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			$objPHPExcel->getActiveSheet()->getStyle('T10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_sw_quality_data($start_date4,$end_date4,$STATION_IDS) as $manual_sw_quality_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_sw_quality_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_sw_quality_data['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_sw_quality_data['RIVER'])
					->setCellValue('E'.$row_no, $manual_sw_quality_data['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_sw_quality_data['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_sw_quality_data['DATETIME'])
					->setCellValue('H'.$row_no, (float)$manual_sw_quality_data['WATER_LVL'])
					->setCellValue('I'.$row_no, (float)$manual_sw_quality_data['BP'])
					->setCellValue('J'.$row_no, (float)$manual_sw_quality_data['TEMPERATURE'])
					->setCellValue('K'.$row_no, (float)$manual_sw_quality_data['PH'])
					->setCellValue('L'.$row_no, (float)$manual_sw_quality_data['DO'])
					->setCellValue('M'.$row_no, (float)$manual_sw_quality_data['SALINITY'])
					->setCellValue('N'.$row_no, (float)$manual_sw_quality_data['TDS'])
					->setCellValue('O'.$row_no, (float)$manual_sw_quality_data['EC'])
					->setCellValue('P'.$row_no, (float)$manual_sw_quality_data['TRANSPARENCY'])
					->setCellValue('Q'.$row_no, (float)$manual_sw_quality_data['FE'])
					->setCellValue('R'.$row_no, (float)$manual_sw_quality_data['CI'])
					->setCellValue('S'.$row_no, round($manual_sw_quality_data['LATITUDE'],5))
					->setCellValue('T'.$row_no, round($manual_sw_quality_data['LONGITUDE'],5));

				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('O'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('P'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('Q'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('R'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');	
				$objPHPExcel->getActiveSheet()->getStyle('S'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				$objPHPExcel->getActiveSheet()->getStyle('T'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*surface water quality data end*/
	}
	else if($DATA_TYPE_ID=='10'){
		/*observed velocity start*/
		if($FREQUENCY_ID=='56'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'RIVER')
				->setCellValue('E10', 'STATION ID')
				->setCellValue('F10', 'STATION NAME')
				->setCellValue('G10', 'DATETIME')
				->setCellValue('H10', 'WATER LEVEL(m)')
				->setCellValue('I10', 'MAX VELOCITY(m/s)')
				->setCellValue('J10', 'MAX DEPTH (m)')
				->setCellValue('K10', 'LATITUDE')
				->setCellValue('L10', 'LONGITUDE');
			
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00000');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_obs_velocity_data($start_date4,$end_date4,$STATION_IDS) as $manual_obs_velocity_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_obs_velocity_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_obs_velocity_data['UZ_NAME'])
					->setCellValue('D'.$row_no, $manual_obs_velocity_data['RIVER_NAME'])
					->setCellValue('E'.$row_no, $manual_obs_velocity_data['STATION_ID'])
					->setCellValue('F'.$row_no, $manual_obs_velocity_data['STATION_NAME'])
					->setCellValue('G'.$row_no, $manual_obs_velocity_data['DATETIME'])
					->setCellValue('H'.$row_no, (float)$manual_obs_velocity_data['WATER_LEVEL_M'])
					->setCellValue('I'.$row_no, (float)$manual_obs_velocity_data['MAX_VELOCITY_M_S'])
					->setCellValue('J'.$row_no, (float)$manual_obs_velocity_data['MAX_DEPTH'])
					->setCellValue('K'.$row_no, round($manual_obs_velocity_data['LATITUDE'],5))
					->setCellValue('L'.$row_no, round($manual_obs_velocity_data['LONGITUDE'],5));

				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*observed velocity end*/
	}
	else if($DATA_TYPE_ID=='1'){
		/*ground water level daily start*/
		if($FREQUENCY_ID=='39'){
			$stat_info_tbl = "GW_STATION_AUTO_MANUAL";
			$stat_info_cols = "WELL_ID,OLD_ID,MANUAL_LAT,MANUAL_LON,DISTRICT_NAME,UPZL_NAME,PARAPET_HGT,RL_PARAPET";
			$stat_info_cond = "WELL_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$old_id = $stat_info['OLD_ID'];
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$parapet_hgt = number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$rl_parapet =  number_format((float)$stat_info['RL_PARAPET'], 2, '.', '');
			
			$latitude = round($stat_info['MANUAL_LAT'],5);
			$longitude = round($stat_info['MANUAL_LON'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue("Well ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue("Old ID: ".$old_id);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue("Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("RL PARAPET (m): ".$rl_parapet);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue("PARAPET HEIGHT (m): ".$parapet_hgt);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE TIME')
				->setCellValue('C11', 'WATER TABLE (m)');
				
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			
			foreach($obj->manual_gw_level_daily_data($start_date4,$end_date4,$STATION_IDS) as $manual_gw_level_daily_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_gw_level_daily_data['DATETIME'])
					->setCellValue('C'.$row_no, (float)$manual_gw_level_daily_data['WATER_TABLE']);

				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		} 
		/*ground water level daily end*/
		/*ground water level weekly start*/
		else if($FREQUENCY_ID=='14'){
			$stat_info_tbl = "GW_STATION_AUTO_MANUAL";
			$stat_info_cols = "WELL_ID,OLD_ID,MANUAL_LAT,MANUAL_LON,DISTRICT_NAME,UPZL_NAME,PARAPET_HGT,RL_PARAPET,DEPTH";
			$stat_info_cond = "WELL_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$old_id = $stat_info['OLD_ID'];
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$parapet_hgt = number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$rl_parapet =  number_format((float)$stat_info['RL_PARAPET'], 2, '.', '');
			$depth = number_format((float)$stat_info['DEPTH'], 2, '.', ''); 
			$latitude = round($stat_info['MANUAL_LAT'],5);
			$longitude = round($stat_info['MANUAL_LON'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue("Well ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue("Old ID: ".$old_id);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue("Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:B10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:B10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('C10:D10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('C10')->setValue("Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('C10:D10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('E10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('E10')->setValue("Depth(m): ".$depth);
			$objPHPExcel->getActiveSheet()->getStyle('E10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("RL PARAPET (m): ".$rl_parapet);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue("PARAPET HEIGHT (m): ".$parapet_hgt);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE TIME')
				->setCellValue('C11', 'WATER TABLE (m)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);	
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.00');
			
			
			foreach($obj->manual_gw_level_weekly_data($start_date4,$end_date4,$STATION_IDS) as $manual_gw_level_weekly_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_gw_level_weekly_data['DATETIME'])
					->setCellValue('C'.$row_no, (float)$manual_gw_level_weekly_data['WATER_LVL']);

				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*ground water level weekly end*/
		/*ground water quality start*/
		else if($FREQUENCY_ID=='13'){
			$row_no = 11;
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'WELL ID')
				->setCellValue('E10', 'OLD ID')
				->setCellValue('F10', 'DATETIME')
				->setCellValue('G10', 'DEPTH (m)')
				->setCellValue('H10', 'TEMPERATURE  (°C)')
				->setCellValue('I10', 'TURBIDITY (NTU)')
				->setCellValue('J10', 'pH ')
				->setCellValue('K10', 'DISSOLVED OXYGEN (mg/l)')
				->setCellValue('L10', 'EH')
				->setCellValue('M10', 'ORP (Mv)')
				->setCellValue('N10', 'EC (µS/cm)')
				->setCellValue('O10', 'TDS (mg/l)')
				->setCellValue('P10', 'SALINITY  (ppt)')
				->setCellValue('Q10', 'HARDNESS CaCO₃ (mg/l)')
				->setCellValue('R10', 'SODIUM Na⁺ (mg/l)')
				->setCellValue('S10', 'POTASSIUM K⁺ (mg/l)')
				->setCellValue('T10', 'CALCIUM Ca²⁺ (mg/l)')
				->setCellValue('U10', 'MAGNESIUM Mg²⁺ (mg/l)')
				->setCellValue('V10', 'NITRATE NO₃⁻ (mg/l)')
				->setCellValue('W10', 'SULPHATE SO₄²⁻  (mg/l)')
				->setCellValue('X10', 'PHOSPHATE PO₄³⁻ (mg/l)')
				->setCellValue('Y10', 'CARBONDIOXIDE CO2²⁻ (mg/l)')
				->setCellValue('Z10', 'CARBONATE CO₃²⁻(mg/l)')
				->setCellValue('AA10', 'BICARBONATE HCO₃⁻(mg/l)')
				->setCellValue('AB10', 'FLUORIDE F⁻(mg/l)')
				->setCellValue('AC10', 'BROMIDE Br⁻(mg/l)')
				->setCellValue('AD10', 'IODIDE I²⁻(mg/l)')
				->setCellValue('AE10', 'CHLORIDE Cl⁻ (mg/l)')
				->setCellValue('AF10', 'ARSENIC As (µg/l)')
				->setCellValue('AG10', 'IRON Fe⁺ (mg/l)')
				->setCellValue('AH10', 'MANGANESE Mn²⁺  (mg/l)')
				->setCellValue('AI10', 'BORON B⁺ (mg/l)')
				->setCellValue('AJ10', 'SILICA Si⁺ (mg/l)')
				->setCellValue('AK10', 'ALUMINIUM Al (mg/l)')
				->setCellValue('AL10', 'COPPER Cu (mg/l)')
				->setCellValue('AM10', 'ZINC Zn (mg/l)')
				->setCellValue('AN10', 'CHROMIUM Cr (mg/l)')
				->setCellValue('AO10', 'SAR (mg/l)');
			
			$objPHPExcel->getActiveSheet()->getStyle('F10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);	
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('N10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('O10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('P10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('Q10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('R10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('S10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('T10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('U10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('V10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('W10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('X10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('Y10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('Z10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AA10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AB10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AC10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AD10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AE10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AF10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AG10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AH10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AI10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AJ10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AK10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AL10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AM10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AN10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('AO10')->getNumberFormat()->setFormatCode('#,##0.00');
			
			foreach($obj->manual_gw_quality_data($start_date4,$end_date4,$STATION_IDS) as $manual_gw_quality_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_gw_quality_data['DISTRICT'])
					->setCellValue('C'.$row_no, $manual_gw_quality_data['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_gw_quality_data['WELL_ID'])
					->setCellValue('E'.$row_no, $manual_gw_quality_data['OLD_ID'])
					->setCellValue('F'.$row_no, $manual_gw_quality_data['DATETIME'])
					->setCellValue('G'.$row_no, $manual_gw_quality_data['DEPTH'])
					->setCellValue('H'.$row_no, (float)$manual_gw_quality_data['TEMPERATURE'])
					->setCellValue('I'.$row_no, (float)$manual_gw_quality_data['TURBILITY'])
					->setCellValue('J'.$row_no, (float)$manual_gw_quality_data['PH'])
					->setCellValue('K'.$row_no, (float)$manual_gw_quality_data['DISSOLVEDOXYGEN'])
					->setCellValue('L'.$row_no, (float)$manual_gw_quality_data['EH'])
					->setCellValue('M'.$row_no, (float)$manual_gw_quality_data['ORP'])
					->setCellValue('N'.$row_no, (float)$manual_gw_quality_data['ELC_CNDUC'])
					->setCellValue('O'.$row_no, (float)$manual_gw_quality_data['TDS'])
					->setCellValue('P'.$row_no, (float)$manual_gw_quality_data['SALINITY'])
					->setCellValue('Q'.$row_no, (float)$manual_gw_quality_data['HARDNESS'])
					->setCellValue('R'.$row_no, (float)$manual_gw_quality_data['SODIUM'])
					->setCellValue('S'.$row_no, (float)$manual_gw_quality_data['POTASSIUM'])
					->setCellValue('T'.$row_no, (float)$manual_gw_quality_data['CALCIUM'])
					->setCellValue('U'.$row_no, (float)$manual_gw_quality_data['MAGNESIUM'])
					->setCellValue('V'.$row_no, (float)$manual_gw_quality_data['NITRATE'])
					->setCellValue('W'.$row_no, (float)$manual_gw_quality_data['SULPHATE'])
					->setCellValue('X'.$row_no, (float)$manual_gw_quality_data['PHOSPHATE'])
					->setCellValue('Y'.$row_no, (float)$manual_gw_quality_data['CARBONDIOXIDE'])
					->setCellValue('Z'.$row_no, (float)$manual_gw_quality_data['CARBONATE'])
					->setCellValue('AA'.$row_no, (float)$manual_gw_quality_data['BICARBONATE'])
					->setCellValue('AB'.$row_no, (float)$manual_gw_quality_data['FLUORIDE'])
					->setCellValue('AC'.$row_no, (float)$manual_gw_quality_data['BROMIDE'])
					->setCellValue('AD'.$row_no, (float)$manual_gw_quality_data['IODIDE'])
					->setCellValue('AE'.$row_no, (float)$manual_gw_quality_data['CHLORIDE'])
					->setCellValue('AF'.$row_no, (float)$manual_gw_quality_data['ARSENIC'])
					->setCellValue('AG'.$row_no, (float)$manual_gw_quality_data['IRON'])
					->setCellValue('AH'.$row_no, (float)$manual_gw_quality_data['MANGANESE'])
					->setCellValue('AI'.$row_no, (float)$manual_gw_quality_data['BORON'])
					->setCellValue('AJ'.$row_no, (float)$manual_gw_quality_data['SILICA'])
					->setCellValue('AK'.$row_no, (float)$manual_gw_quality_data['ALUMINIUM'])
					->setCellValue('AL'.$row_no, (float)$manual_gw_quality_data['COPPER'])
					->setCellValue('AM'.$row_no, (float)$manual_gw_quality_data['ZINC'])
					->setCellValue('AN'.$row_no, (float)$manual_gw_quality_data['CHROMIUM'])
					->setCellValue('AO'.$row_no, (float)$manual_gw_quality_data['SAR']);

				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('O'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('P'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('Q'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('R'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('S'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('T'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('U'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('V'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('W'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('X'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('Y'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('Z'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AA'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AB'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AC'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AD'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AE'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AF'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AG'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AH'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AI'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AJ'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AK'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AL'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AM'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AN'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('AO'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);			
		}
		/*ground water quality end*/
		/*lithology start*/
		else if($FREQUENCY_ID=='31'){
			$row_no=10;
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A9', 'SL')
				->setCellValue('B9', 'DISTRICT')
				->setCellValue('C9', 'UPAZILA')
				->setCellValue('D9', 'BOREHOLL ID')
				->setCellValue('E9', 'MOUZA')
				->setCellValue('F9', 'VILLAGE')
				->setCellValue('G9', 'START DATE')
				->setCellValue('H9', 'END DATE')
				->setCellValue('I9', 'DEPTH')
				->setCellValue('J9', 'COLOR')
				->setCellValue('K9', 'LITHOLOGY')
				->setCellValue('L9', 'LATITUDE')
				->setCellValue('M9', 'LONGITUDE');
			
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			$objPHPExcel->getActiveSheet()->getStyle('A9:M9')->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A9:M9')->getAlignment()->setHorizontal('center');
			
			foreach($obj->manual_lithology_data($start_date4,$end_date4,$STATION_IDS) as $manual_lithology_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_lithology_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_lithology_data['UPAZILA'])
					->setCellValue('D'.$row_no, $manual_lithology_data['BOREHOLL_ID'])
					->setCellValue('E'.$row_no, $manual_lithology_data['MOUZA'])
					->setCellValue('F'.$row_no, $manual_lithology_data['VILLAGE'])
					->setCellValue('G'.$row_no, $manual_lithology_data['START_DATE'])
					->setCellValue('H'.$row_no, $manual_lithology_data['END_DATE'])
					->setCellValue('I'.$row_no, (float)$manual_lithology_data['DEPTH'])
					->setCellValue('J'.$row_no, $manual_lithology_data['COLOR'])
					->setCellValue('K'.$row_no, $manual_lithology_data['LITHOLOGY'])
					->setCellValue('L'.$row_no, round($manual_lithology_data['LATITUDE'],5))
					->setCellValue('M'.$row_no, round($manual_lithology_data['LONGITUDE'],5));

				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');
				
				$row_no++;
			}
			$row_no_1 = $row_no+1;
			$row_no_2 = $row_no+3;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no_1.':M'.$row_no_1);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no_1)->setValue("Note: >50% = Dominante size, 50%-50% = and, 20%-40% = some, 10%-20% = little, <10% = trace");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_1.':M'.$row_no_1)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_1.':M'.$row_no_1)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_1.':M'.$row_no_1)->getAlignment()->setHorizontal('center');
			
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no_2.':M'.$row_no_2);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no_2)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_2.':M'.$row_no_2)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_2.':M'.$row_no_2)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no_2.':M'.$row_no_2)->getFont()->setItalic(true);
		}
		/*lithology end*/
		/*pump test start*/
		else if($FREQUENCY_ID=='51'){
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A10', 'SL')
				->setCellValue('B10', 'DISTRICT')
				->setCellValue('C10', 'UPAZILA')
				->setCellValue('D10', 'WELL ID')
				->setCellValue('E10', 'MOUZA')
				->setCellValue('F10', 'VILLAGE')
				->setCellValue('G10', 'START DATE')
				->setCellValue('H10', 'END DATE')
				->setCellValue('I10', 'DURATION')
				->setCellValue('J10', 'SWT')
				->setCellValue('K10', 'DISCHARGE')
				->setCellValue('L10', 'MAXDD')
				->setCellValue('M10', 'PARAPET_HEIGHT')
				->setCellValue('N10', 'RESULT_K')
				->setCellValue('O10', 'RESULT_T')
				->setCellValue('P10', 'RESULT_S')
				->setCellValue('Q10', 'LEAKAGE FACT')
				->setCellValue('R10', 'LATITUDE')
				->setCellValue('S10', 'LONGITUDE');
				
			$objPHPExcel->getActiveSheet()->getStyle('G10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('H10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('I10')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('J10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('K10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('L10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('M10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('N10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('O10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('P10')->getNumberFormat()->setFormatCode('#,##0.00');
			$objPHPExcel->getActiveSheet()->getStyle('R10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			$objPHPExcel->getActiveSheet()->getStyle('S10')->getNumberFormat()->setFormatCode('#,##0.00000');	
			
			foreach($obj->manual_pump_test_data($start_date4,$end_date4,$STATION_IDS) as $manual_pump_test_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $manual_pump_test_data['DISTRICT_NAME'])
					->setCellValue('C'.$row_no, $manual_pump_test_data['UPAZILA_NAME'])
					->setCellValue('D'.$row_no, $manual_pump_test_data['WELL_ID'])
					->setCellValue('E'.$row_no, $manual_pump_test_data['MOUZA'])
					->setCellValue('F'.$row_no, $manual_pump_test_data['VILLAGE'])
					->setCellValue('G'.$row_no, $manual_pump_test_data['START_DATE'])
					->setCellValue('H'.$row_no, $manual_pump_test_data['END_DATE'])
					->setCellValue('I'.$row_no, (int)$manual_pump_test_data['DURATION'])
					->setCellValue('J'.$row_no, (float)$manual_pump_test_data['SWT'])
					->setCellValue('K'.$row_no, (float)$manual_pump_test_data['DISCHARGE'])
					->setCellValue('L'.$row_no, (float)$manual_pump_test_data['MAXDD'])
					->setCellValue('M'.$row_no, (float)$manual_pump_test_data['PARAPET_HEIGHT'])
					->setCellValue('N'.$row_no, (float)$manual_pump_test_data['RESULT_K'])
					->setCellValue('O'.$row_no, (float)$manual_pump_test_data['RESULT_T'])
					->setCellValue('P'.$row_no, (float)$manual_pump_test_data['RESULT_S'])
					->setCellValue('Q'.$row_no, (float)$manual_pump_test_data['LEAKAGE_FACT'])
					->setCellValue('R'.$row_no, round($manual_pump_test_data['LATITUDE'],5))
					->setCellValue('S'.$row_no, round($manual_pump_test_data['LONGITUDE'],5));
					
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('O'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('P'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00');
				$objPHPExcel->getActiveSheet()->getStyle('R'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				$objPHPExcel->getActiveSheet()->getStyle('S'.$row_no)->getNumberFormat()->setFormatCode('#,##0.00000');	
				
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		} 
		/*pump test end*/
	}
	else if($DATA_TYPE_ID=='12'){
		/*Auto Water Level 15 m Inst start*/
		if($FREQUENCY_ID=='58'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'Sl')
				->setCellValue('B11', 'Date Time')
				->setCellValue('C11', 'Water Level (m)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_water_level_fifteen_mins_inst($start_date4,$end_date4,$STATION_IDS) as $auto_inst_data){
				$x++;
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $auto_inst_data['DATETIME'])
					->setCellValue('C'.$row_no, (float)$auto_inst_data['VALUE']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Water Level 15 m Inst end*/
		/*Auto Water Level 3-hourly start*/
		if($FREQUENCY_ID=='67'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'Sl')
				->setCellValue('B11', 'Date Time')
				->setCellValue('C11', 'Water Level (m)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B10')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('C10')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_water_level_three_hrly_inst($start_date4,$end_date4,$STATION_IDS) as $auto_water_level_three_hrly_inst){
				$x++;
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $auto_water_level_three_hrly_inst['DATETIME'])
					->setCellValue('C'.$row_no, (float)$auto_water_level_three_hrly_inst['VALUE']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
			
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Water Level 3-hourly end*/
		/*Auto Water Level Daily start*/
		if($FREQUENCY_ID=='64' || $FREQUENCY_ID=='91'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'Sl')
				->setCellValue('B11', 'Date')
				->setCellValue('C11', 'Daily Max WL (mMSL)')
				->setCellValue('D11', 'Daily MIN WL (mMSL)')
				->setCellValue('E11', 'Daily AVG WL (mMSL)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_water_level_daily_data($start_date4,$end_date4,$STATION_IDS) as $auto_water_level_daily_data){
				$x++;
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $auto_water_level_daily_data['DT'])
					->setCellValue('C'.$row_no, (float)$auto_water_level_daily_data['MAX_WL'])
					->setCellValue('D'.$row_no, (float)$auto_water_level_daily_data['MIN_WL'])
					->setCellValue('E'.$row_no, (float)$auto_water_level_daily_data['AVG_WL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
			
				$row_no++;
			}	
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Water Level Daily end*/
		/*Auto Water Level Monthly end*/
		if($FREQUENCY_ID=='65' || $FREQUENCY_ID=='92'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'Sl')
				->setCellValue('B11', 'Year')
				->setCellValue('C11', 'Month')
				->setCellValue('D11', 'Monthly Max Date')
				->setCellValue('E11', 'Monthly Max WL (mMSL)')
				->setCellValue('F11', 'Monthly Min Date')
				->setCellValue('G11', 'Monthly MIN WL (mMSL)')
				->setCellValue('H11', 'Monthly AVG WL (mMSL)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('H11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_water_level_monthly_data($start_date4,$end_date4,$STATION_IDS) as $auto_water_level_monthly_data){
				$x++;
				$sel_my_arr = explode("-",$auto_water_level_monthly_data['MONTH_YEAR']);
				$sel_year = (int)$sel_my_arr[0];
				$sel_mon = (int)$sel_my_arr[1];
				
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $sel_year)
					->setCellValue('C'.$row_no, $sel_mon)
					->setCellValue('D'.$row_no, $auto_water_level_monthly_data['MAX_DATE'])
					->setCellValue('E'.$row_no, number_format((float)$auto_water_level_monthly_data['MAX_VALUE'], 3, '.', ''))
					->setCellValue('F'.$row_no, $auto_water_level_monthly_data['MIN_DATE'])
					->setCellValue('G'.$row_no, number_format((float)$auto_water_level_monthly_data['MIN_VALUE'], 3, '.', ''))
					->setCellValue('H'.$row_no, number_format((float)$auto_water_level_monthly_data['AVG_VALUE'], 3, '.', ''));
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
			
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Water Level Monthly end*/
		/*Auto Water Level Yearly start*/
		if($FREQUENCY_ID=='66' || $FREQUENCY_ID=='93'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'Sl')
				->setCellValue('B11', 'Year')
				->setCellValue('C11', 'Yearly Max Date')
				->setCellValue('D11', 'Yearly Max WL (mMSL)')
				->setCellValue('E11', 'Yearly Min Date')
				->setCellValue('F11', 'Yearly MIN WL (mMSL)')
				->setCellValue('G11', 'Yearly AVG WL (mMSL)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_water_level_yearly_data($start_date4,$end_date4,$STATION_IDS) as $auto_water_level_yearly_data){
				$x++;

				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$auto_water_level_yearly_data['YEAR'])
					->setCellValue('C'.$row_no, $auto_water_level_yearly_data['MAX_DATE'])
					->setCellValue('D'.$row_no, number_format((float)$auto_water_level_yearly_data['MAX_VALUE'], 3, '.', ''))
					->setCellValue('E'.$row_no, $auto_water_level_yearly_data['MIN_DATE'])
					->setCellValue('F'.$row_no, number_format((float)$auto_water_level_yearly_data['MIN_VALUE'], 3, '.', ''))
					->setCellValue('G'.$row_no, number_format((float)$auto_water_level_yearly_data['AVG_VALUE'], 3, '.', ''));
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
			
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Water Level Yearly end*/
		/*Auto Maximum Flood Level start*/
		else if($FREQUENCY_ID=='90'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$river_name = $stat_info['RIVER_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$tidal_status = "";
			if ($stat_info['TIDAL_STS'] == 'T') {
				$tidal_status = 'Tidal';
			} else {
				$tidal_status = 'Non Tidal';
			}
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "River Name: ".$river_name);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Station Type: ".$tidal_status);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'Date')
				->setCellValue('C11', 'Recorded Highest WL (mMSL)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');

			foreach($obj->auto_water_level_maximum_flood_level($STATION_IDS) as $rt_maximum_flood_level){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $rt_maximum_flood_level['DT'])
					->setCellValue('C'.$row_no, (float)$rt_maximum_flood_level['READ_VAL']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Maximum Flood Level end*/
	}
	else if($DATA_TYPE_ID=='11'){
		/*Auto Ground Water Level hourly*/
		if($FREQUENCY_ID=='63'){
			$stat_info_tbl = "GW_STATION_AUTO_MANUAL";
			$stat_info_cols = "STATION_CODE,AUTO_LAT,AUTO_LONG,DISTRICT_NAME,UPZL_NAME,PARAPET_HGT,RL_PARAPET,DEPTH";
			$stat_info_cond = "STATION_CODE='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$well_id = $stat_info['STATION_CODE'];
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$parapet_hgt = number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$rl_parapet =  number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$depth = number_format((float)$stat_info['DEPTH'], 2, '.', ''); 
			
			$latitude = round($stat_info['AUTO_LAT'],5);
			$longitude = round($stat_info['AUTO_LONG'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue("Well ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue("District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue("Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("Depth(m): ".$depth);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("RL PARAPET (m): ".$rl_parapet);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue("PARAPET HEIGHT (m): ".$parapet_hgt);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE TIME')
				->setCellValue('C11', 'WATER LEVEL (m)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_ground_water_level_hourly($start_date4,$end_date4,$STATION_IDS) as $gwt_hrly_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $gwt_hrly_data['DATETIME'])
					->setCellValue('C'.$row_no, (float)$gwt_hrly_data['VALUE']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Ground Water Level hourly*/
		/*Auto Ground Water Level daily*/
		if($FREQUENCY_ID=='97'){
			$stat_info_tbl = "GW_STATION_AUTO_MANUAL";
			$stat_info_cols = "STATION_CODE,AUTO_LAT,AUTO_LONG,DISTRICT_NAME,UPZL_NAME,PARAPET_HGT,RL_PARAPET,DEPTH";
			$stat_info_cond = "STATION_CODE='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$well_id = $stat_info['STATION_CODE'];
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$parapet_hgt = number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$rl_parapet =  number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$depth = number_format((float)$stat_info['DEPTH'], 2, '.', ''); 
			
			$latitude = round($stat_info['AUTO_LAT'],5);
			$longitude = round($stat_info['AUTO_LONG'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue("Well ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue("District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue("Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("Depth(m): ".$depth);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("RL PARAPET (m): ".$rl_parapet);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue("PARAPET HEIGHT (m): ".$parapet_hgt);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE')
				->setCellValue('C11', 'WATER LEVEL (m)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_ground_water_level_daily($start_date4,$end_date4,$STATION_IDS) as $gwt_daily_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $gwt_daily_data['SHOW_DATE'])
					->setCellValue('C'.$row_no, (float)$gwt_daily_data['SUM_VAL']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Ground Water Level daily*/
		/*Auto Ground Water Level weekly*/
		if($FREQUENCY_ID=='98'){
			$stat_info_tbl = "GW_STATION_AUTO_MANUAL";
			$stat_info_cols = "STATION_CODE,AUTO_LAT,AUTO_LONG,DISTRICT_NAME,UPZL_NAME,PARAPET_HGT,RL_PARAPET,DEPTH";
			$stat_info_cond = "STATION_CODE='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$well_id = $stat_info['STATION_CODE'];
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$parapet_hgt = number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$rl_parapet =  number_format((float)$stat_info['PARAPET_HGT'], 2, '.', '');
			$depth = number_format((float)$stat_info['DEPTH'], 2, '.', ''); 
			
			$latitude = round($stat_info['AUTO_LAT'],5);
			$longitude = round($stat_info['AUTO_LONG'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue("Well ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue("District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue("Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue("Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue("Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue("Depth(m): ".$depth);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G10:I10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G10')->setValue("RL PARAPET (m): ".$rl_parapet);
			$objPHPExcel->getActiveSheet()->getStyle('G10:I10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J10:L10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J10')->setValue("PARAPET HEIGHT (m): ".$parapet_hgt);
			$objPHPExcel->getActiveSheet()->getStyle('J10:L10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE')
				->setCellValue('C11', 'WATER LEVEL (m)');
			
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_ground_water_level_weekly($start_date4,$end_date4,$STATION_IDS) as $gwt_weekly_data){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $gwt_weekly_data['SHOW_DATE'])
					->setCellValue('C'.$row_no, (float)$gwt_weekly_data['SUM_VAL']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*Auto Ground Water Level weekly*/
	}
	else if($DATA_TYPE_ID=='13'){
		/* auto rainfall hourly start*/
		if($FREQUENCY_ID=='59'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE')
				->setCellValue('C11', 'RAIN FALL(mm)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			/*$res = $obj->auto_rainfall_hourly_debugger($start_date4,$end_date4,$STATION_IDS);
			$objPHPExcel->setActiveSheetIndex(0)->setCellValue('A11', $res);*/
			foreach($obj->auto_rainfall_hourly($start_date4,$end_date4,$STATION_IDS) as $auto_rf_hrly){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $auto_rf_hrly['DATETIME'])
					->setCellValue('C'.$row_no, (float)$auto_rf_hrly['VALUE']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*auto rainfall hourly end*/
		/* auto rainfall daily start*/
		if($FREQUENCY_ID=='99'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'DATE')
				->setCellValue('C11', 'RAIN FALL(mm)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);			
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_rainfall_daily($start_date4,$end_date4,$STATION_IDS) as $auto_rainfall_daily){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, $auto_rainfall_daily['DT'])
					->setCellValue('C'.$row_no, (float)$auto_rainfall_daily['SARF']);
					
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode(\PhpOffice\PhpSpreadsheet\Style\NumberFormat::FORMAT_DATE_YYYYMMDDSLASH);
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*auto rainfall daily end*/
		/*auto rainfall monthly start*/
		else if($FREQUENCY_ID=='100'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'YEAR')
				->setCellValue('C11', 'JAN')
				->setCellValue('D11', 'FEB')
				->setCellValue('E11', 'MAR')
				->setCellValue('F11', 'APR')
				->setCellValue('G11', 'MAY')
				->setCellValue('H11', 'JUN')
				->setCellValue('I11', 'JUL')
				->setCellValue('J11', 'AUG')
				->setCellValue('K11', 'SEP')
				->setCellValue('L11', 'OCT')
				->setCellValue('M11', 'NOV')
				->setCellValue('N11', 'DEC')
				->setCellValue('O11', 'YEAR TOTAL');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('D11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('E11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('F11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('G11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('H11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('I11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('J11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('K11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('L11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('M11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('N11')->getNumberFormat()->setFormatCode('#,##0.000');
			$objPHPExcel->getActiveSheet()->getStyle('O11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_rainfall_monthly($start_date4,$end_date4,$STATION_IDS) as $auto_rainfall_monthly){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$auto_rainfall_monthly['YEAR'])
					->setCellValue('C'.$row_no, (float)$auto_rainfall_monthly['JAN'])
					->setCellValue('D'.$row_no, (float)$auto_rainfall_monthly['FEB'])
					->setCellValue('E'.$row_no, (float)$auto_rainfall_monthly['MAR'])
					->setCellValue('F'.$row_no, (float)$auto_rainfall_monthly['APR'])
					->setCellValue('G'.$row_no, (float)$auto_rainfall_monthly['MAY'])
					->setCellValue('H'.$row_no, (float)$auto_rainfall_monthly['JUN'])
					->setCellValue('I'.$row_no, (float)$auto_rainfall_monthly['JUL'])
					->setCellValue('J'.$row_no, (float)$auto_rainfall_monthly['AUG'])
					->setCellValue('K'.$row_no, (float)$auto_rainfall_monthly['SEP'])
					->setCellValue('L'.$row_no, (float)$auto_rainfall_monthly['OCT'])
					->setCellValue('M'.$row_no, (float)$auto_rainfall_monthly['NOV'])
					->setCellValue('N'.$row_no, (float)$auto_rainfall_monthly['DEC'])
					->setCellValue('O'.$row_no, (float)$auto_rainfall_monthly['YR_RF_TOTAL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('D'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('E'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('F'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('G'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('H'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('I'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('J'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('K'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('L'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('M'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('N'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$objPHPExcel->getActiveSheet()->getStyle('O'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*auto rainfall monthly end*/
		/*auto rainfall annual start*/
		else if($FREQUENCY_ID=='101'){
			$stat_info_tbl = "SW_STATION_AUTO_MANUAL";
			$stat_info_cols = "DISTRICT_NAME,UPZL_NAME,RIVER_NAME,STATION_NAME,TIDAL_STS,LATITUDE,LONGITUDE,RT,SOB_DATE";
			$stat_info_cond = "STATION_ID='$STATION_IDS'";
			$stat_info = $obj->View_column_details_By_Cond($stat_info_tbl,$stat_info_cols,$stat_info_cond);
			
			$district_name = $stat_info['DISTRICT_NAME'];
			$upazila = $stat_info['UPZL_NAME'];
			$station_name = $stat_info['STATION_NAME'];
			$latitude = round($stat_info['LATITUDE'],5);
			$longitude = round($stat_info['LONGITUDE'],5);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A9:C9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A9')->setValue( "Station ID: ".$STATION_IDS);
			$objPHPExcel->getActiveSheet()->getStyle('A9:C9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D9:F9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D9')->setValue( "Station Name: ".$station_name);
			$objPHPExcel->getActiveSheet()->getStyle('D9:F9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('G9:I9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('G9')->setValue( "District: ".$district_name);
			$objPHPExcel->getActiveSheet()->getStyle('G9:I9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('J9:L9');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('J9')->setValue( "Upazila: ".$upazila);
			$objPHPExcel->getActiveSheet()->getStyle('J9:L9')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('A10:C10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A10')->setValue( "Latitude: ".$latitude);
			$objPHPExcel->getActiveSheet()->getStyle('A10:C10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
			$objPHPExcel->setActiveSheetIndex(0)->getCell('D10')->setValue( "Longitude: ".$longitude);
			$objPHPExcel->getActiveSheet()->getStyle('D10:F10')->getAlignment()->setWrapText(true);
			
			$objPHPExcel->getActiveSheet()->getStyle('A1:L10')->getFont()->setBold(true);
			
			$objPHPExcel->setActiveSheetIndex(0)
				->setCellValue('A11', 'SL')
				->setCellValue('B11', 'YEAR')
				->setCellValue('C10', 'TOTAL RAIN FALL(mm)');
				
			$objPHPExcel->getActiveSheet()->getStyle('B11')->getNumberFormat()->setFormatCode('####');
			$objPHPExcel->getActiveSheet()->getStyle('C11')->getNumberFormat()->setFormatCode('#,##0.000');
			
			foreach($obj->auto_rainfall_yearly($start_date4,$end_date4,$STATION_IDS) as $auto_rainfall_annual){
				$x++;
				$objPHPExcel->setActiveSheetIndex(0)
					->setCellValue('A'.$row_no, $x)
					->setCellValue('B'.$row_no, (int)$auto_rainfall_annual['YEAR'])
					->setCellValue('C'.$row_no, (float)$auto_rainfall_annual['RAINFALL']);
				
				$objPHPExcel->getActiveSheet()->getStyle('B'.$row_no)->getNumberFormat()->setFormatCode('####');
				$objPHPExcel->getActiveSheet()->getStyle('C'.$row_no)->getNumberFormat()->setFormatCode('#,##0.000');
				$row_no++;
			}
			$row_no = $row_no+1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$row_no.':M'.$row_no);
			$objPHPExcel->setActiveSheetIndex(0)->getCell('A'.$row_no)->setValue("This document is system generated and does not require any signature.");
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getAlignment()->setWrapText(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setBold(true);
			$objPHPExcel->getActiveSheet()->getStyle('A'.$row_no.':M'.$row_no)->getFont()->setItalic(true);
		}
		/*auto rainfall annual end*/
	}
	$writer = new Xlsx($objPHPExcel);

	$writer->save($filename);
	
	echo trim($dr_filename);
//	unlink($filename);
?>

