<?php
session_start();
include("../../php_crud/my_class.php");
$obj = new my_class();
$user_id = $_SESSION['LOGIN_USERID'];
extract($_GET);
$db_from_date = date("d-M-y", strtotime($from_date));
$db_to_date = date("d-M-y", strtotime($to_date));
$db_from_date = strtoupper($db_from_date);
$db_to_date = strtoupper($db_to_date);
//echo "from date: $from_date, to date: $to_date";
$show_from_date = date('j F, Y', strtotime($from_date));
$show_to_date = date('j F, Y', strtotime($to_date));
function convert_number2($number)
{
	if (($number < 0) || ($number > 999999999)) {
		//throw new Exception("Number is out of range");
		echo "Number range is over!";
	}

	/* Crore */
	$Cn = floor($number / 10000000);
	$number -= $Cn * 10000000;

	/* Lacs  */
	$Gn = floor($number / 100000);
	$number -= $Gn * 100000;

	/* Thousands */
	$kn = floor($number / 1000);
	$number -= $kn * 1000;

	/* Hundreds */
	$Hn = floor($number / 100);
	$number -= $Hn * 100;

	/* Tens  */
	$Dn = floor($number / 10);

	/* Ones */
	$n   = $number % 10;
	$res = "";

	if ($Cn) {
		$res .= convert_number2($Cn) . " Crore ";
	}
	if ($Gn) {
		$res .= convert_number2($Gn) . " Lakh";
	}
	if ($kn) {
		$res .= (empty($res) ? "" : " ") . convert_number2($kn) . " Thousand";
	}
	if ($Hn) {
		$res .= (empty($res) ? "" : " ") . convert_number2($Hn) . " Hundred";
	}

	$ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");

	$tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");

	if ($Dn || $n) {
		if (!empty($res)) {
			$res .= " and ";
		}
		if ($Dn < 2) {
			$res .= $ones[$Dn * 10 + $n];
		} else {
			$res .= $tens[$Dn];
			if ($n) {
				$res .= "-" . $ones[$n];
			}
		}
	}
	if (empty($res)) {
		$res = "zero";
	}
	return $res;
}
?>
<h2 style="text-align: center; color: #3333cc; font-weight: bold;">Total Collection Report from <?php echo $show_from_date; ?> to <?php echo $show_to_date; ?></h2>
<table id="payment_report_datatbl" class="table table-striped table-bordered table-hover">
	<thead>
		<tr>
			<th style="text-align: center;">Sn.</th>
			<th style="text-align: center;">User Information</th>
			<!-- <th style="text-align: center;">Data Request Date</th> -->
			<th style="text-align: center;">Payment Information</th>
			<!-- <th style="text-align: center;">Address</th> -->
			<th style="text-align: center;">Data Request Date</th>
			<th style="text-align: center;">Amount</th>
		</tr>
		<!-- <tr>
      <th style="text-align: center;">Number</th>
      <th style="text-align: center;">Issue Date</th>
      <th style="text-align: center;">Bank Name</th>
    </tr> -->
	</thead>
	<tbody>
		<?php
		$i = 0;
		$grand_total = 0;
		if ($from_date != '' && $to_date != '' && $payment_method != '') {
			$pay_rep_cond = "TRANSACTION_DATETIME>=TO_DATE('$db_from_date','DD-MON-RR') AND TRANSACTION_DATETIME<=TO_DATE('$db_to_date','DD-MON-RR')+1 AND TRANSACTION_STATUS='Success' AND PAYMENT_METHOD='$payment_method' ORDER BY TRANSACTION_DATETIME DESC";
		} else {
			$pay_rep_cond = "TRANSACTION_DATETIME>=TO_DATE('$db_from_date','DD-MON-RR') AND 
TRANSACTION_DATETIME<=TO_DATE('$db_to_date','DD-MON-RR') 
AND TRANSACTION_STATUS='Success' ORDER BY TRANSACTION_DATETIME DESC";
		}


		$pay_rep_cols = "USER_ID,USER_FULLNAME,EMAIL,MOBILE,DATA_REQUEST_ID,TRANSACTION_CODE,TO_CHAR(TRANSACTION_DATETIME,'DD MON,YYYY HH24:MI:SS') AS TRANS_DT,TOTAL_PAYABLES,CH_PO_NO,CH_PO_ISSUE_DATE,CH_PO_ISSUE_BANK,TRANSACTION_AMOUNT";
		$pay_rep_tbl = "SITE_PAYMENT_LOG";
		//echo $pay_rep_cond;
		// 		$pay_rep_cond = "TRANSACTION_DATETIME>=TO_DATE('$db_from_date','DD-MON-RR') AND 
		// TRANSACTION_DATETIME<=TO_DATE('$db_to_date','DD-MON-RR') 
		// AND TRANSACTION_STATUS='Success' AND PAYMENT_METHOD='2' ORDER BY TRANSACTION_DATETIME DESC";
		//echo $obj->View_colmn_By_Cond_debugger($pay_rep_tbl,"*",$pay_rep_cond);
		foreach ($obj->View_colmn_By_Cond($pay_rep_tbl, $pay_rep_cols, $pay_rep_cond) as $pay_rep) {
			$i++;
			$total_amount = $pay_rep['TOTAL_PAYABLES'];
			$pay_user_id = $pay_rep['USER_ID'];
			$total_trans_amount = $pay_rep['TRANSACTION_AMOUNT'];
			$grand_total = $grand_total + $total_trans_amount;

			$get_user_type = $obj->View_column_details_By_Cond("SITE_USER_ACL SUA LEFT JOIN SITE_USER_TYPE SUT ON SUA.USER_TYPE_ID = SUT.ID", "SUA.USER_TYPE_ID AS USER_TYPE_ID, SUT.USER_TYPE_NAME AS USER_TYPE_NAME,SUA.NAME AS USER_NAME", "SUA.USER_ID = '$pay_user_id' AND SUT.SHOW=1");
			$user_type_name = $get_user_type['USER_TYPE_NAME'];
			// $user_type_name = $get_user_type['USER_NAME'];
		?>
			<tr>
				<td><?php echo $i; ?></td>
				<td>
					<b> User ID: </b><?php echo $pay_rep['USER_ID']; ?><br/>
					<b> User Name: </b><?php echo $get_user_type['USER_NAME']; ?><br />
					<b> email: </b><?php echo $pay_rep['EMAIL']; ?><br />
					<b> Mobile: </b><?php echo $pay_rep['MOBILE']; ?><br />
					<b> User Type: </b><?php echo $user_type_name; ?>
				</td>

				<td>
					<?php
					$po_no = !empty($pay_rep['CH_PO_NO']) ? $pay_rep['CH_PO_NO'] : null;
					$po_issue_date = !empty($pay_rep['CH_PO_ISSUE_DATE']) ? $pay_rep['CH_PO_ISSUE_DATE'] : null;
					$po_bank_name = !empty($pay_rep['CH_PO_ISSUE_BANK']) ? $pay_rep['CH_PO_ISSUE_BANK'] : null;
					$invoice_no = !empty($pay_rep['DATA_REQUEST_ID']) ? $pay_rep['DATA_REQUEST_ID'] : null;

					if (is_null($po_no) && is_null($po_issue_date) && is_null($po_bank_name) && is_null($invoice_no)) {
						echo 'N/A';
					} else {
						echo "<b> Invoice No: </b>" . ($invoice_no ?? 'N/A') . "<br/>";
						echo "<b> Pay Order/Cheque No: </b>" . ($po_no ?? 'N/A') . "<br/>";
						echo "<b> Pay Order/Cheque Issue Date: </b>" . ($po_issue_date ?? 'N/A') . "<br/>";
						echo "<b> Pay Order/Cheque Bank Name: </b>" . ($po_bank_name ?? 'N/A');
					}
					?>
				</td>

				<td style="text-align: center;"><?php 
					if (empty($pay_rep['TRANS_DT'])) {
						echo 'N/A';
					} else {
						echo $pay_rep['TRANS_DT'];
					} ?>
				</td>

				<td style="text-align: right;"><?php echo "$total_trans_amount BDT."; ?> </td>
			</tr>
		<?php	}
		$grand_total_in_word = convert_number2($grand_total);
		?>
	</tbody>
	<tfoot>
		<tr>
			<td colspan="4" style="text-align: right; font-weight: bold; padding-right: 2px;">Total:</td>
			<td style="text-align: right; font-weight: bold;"><?php echo "$grand_total BDT."; ?></td>
		</tr>
		<tr>
			<td colspan="5">
				<b>Amount in word:</b> <?php echo $grand_total_in_word; ?> Taka Only
			</td>
		</tr>
	</tfoot>
</table>

<script type="text/javascript">
	var oTable2 = $('#payment_report_datatbl').DataTable({
		"columns": [{
				"orderable": true
			},
			null, null, null,
			{
				"orderable": true
			}
		],
		"iDisplayLength": 50
	});
</script>