<?php
session_start();
require_once '../../asset/mpdf/vendor/autoload.php';
include("../../php_crud/my_class.php");
$obj = new my_class();
$user_id = $_SESSION['LOGIN_USERID'];
extract($_GET);
$db_from_date = date("d-M-y", strtotime($from_date));
$db_to_date = date("d-M-y", strtotime($to_date));
$db_from_date = strtoupper($db_from_date);
$db_to_date = strtoupper($db_to_date);
//echo "from date: $from_date, to date: $to_date";
$show_from_date = date('j F, Y', strtotime($from_date));
$show_to_date = date('j F, Y', strtotime($to_date));
function convert_number2($number)
{
	if (($number < 0) || ($number > 999999999)) {
		//throw new Exception("Number is out of range");
		echo "Number range is over!";
	}

	/* Crore */
	$Cn = floor($number / 10000000);
	$number -= $Cn * 10000000;

	/* Lacs  */
	$Gn = floor($number / 100000);
	$number -= $Gn * 100000;

	/* Thousands */
	$kn = floor($number / 1000);
	$number -= $kn * 1000;

	/* Hundreds */
	$Hn = floor($number / 100);
	$number -= $Hn * 100;

	/* Tens  */
	$Dn = floor($number / 10);

	/* Ones */
	$n   = $number % 10;
	$res = "";

	if ($Cn) {
		$res .= convert_number2($Cn) . " Crore ";
	}
	if ($Gn) {
		$res .= convert_number2($Gn) . " Lakh";
	}
	if ($kn) {
		$res .= (empty($res) ? "" : " ") . convert_number2($kn) . " Thousand";
	}
	if ($Hn) {
		$res .= (empty($res) ? "" : " ") . convert_number2($Hn) . " Hundred";
	}

	$ones = array("", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eightteen", "Nineteen");

	$tens = array("", "", "Twenty", "Thirty", "Fourty", "Fifty", "Sixty", "Seventy", "Eigthy", "Ninety");

	if ($Dn || $n) {
		if (!empty($res)) {
			$res .= " and ";
		}
		if ($Dn < 2) {
			$res .= $ones[$Dn * 10 + $n];
		} else {
			$res .= $tens[$Dn];
			if ($n) {
				$res .= "-" . $ones[$n];
			}
		}
	}
	if (empty($res)) {
		$res = "zero";
	}
	return $res;
}

$html = "<html><head></head>
<style>
	.th_left_bottom_border{
		font-weight: bold; 
		text-align: center;
		border-left: 1px solid; 
		border-bottom: 1px solid; 
	}

	.th_left_right_bottom_border{
		font-weight: bold; 
		text-align: center;
		border-left: 1px solid; 
		border-bottom: 1px solid; 
		border-right: 1px solid;
	}

	.td_left_bottom_border{
		border-left: 1px solid; 
		border-bottom: 1px solid; 
	}

	.td_left_right_bottom_border{
		border-left: 1px solid; 
		border-bottom: 1px solid; 
		border-right: 1px solid;
	}
</style>
<body>";
if ($payment_method == 2) {
	$payment_name = 'Offline';
}
if ($payment_method == 1) {
	$payment_name = 'Online';
}
$html .= "<div><h3 style='text-align:center;'>Hydrological $payment_name Payment Report From $show_from_date To $show_to_date</h3></div>";
$html .= '<table style="width: 100%; border-collapse: collapse;" border="1">
<thead>
    <tr>
        <th style="text-align: center;">Sl</th>
        <th style="text-align: center;">User Information</th>
        <th style="text-align: center;">Payment Information</th>
        <th style="text-align: center;">Data Request Date</th>
        <th style="text-align: center;">Amount</th>
    </tr>
</thead>';
$i = 0;
$grand_total = 0;

if ($from_date != '' && $to_date != '' && $payment_method != '') {
	$pay_rep_cond = "TRANSACTION_DATETIME>=TO_DATE('$db_from_date','DD-MON-RR') AND TRANSACTION_DATETIME<=TO_DATE('$db_to_date','DD-MON-RR')+1 AND TRANSACTION_STATUS='Success' AND PAYMENT_METHOD='$payment_method' ORDER BY TRANSACTION_DATETIME ASC";
} else {
	$pay_rep_cond = "TRANSACTION_DATETIME>=TO_DATE('$db_from_date','DD-MON-RR') AND TRANSACTION_DATETIME<=TO_DATE('$db_to_date','DD-MON-RR') AND TRANSACTION_STATUS='Success' ORDER BY TRANSACTION_DATETIME ASC";
}

$pay_rep_cols = "USER_ID,USER_FULLNAME,EMAIL,MOBILE,DATA_REQUEST_ID,TRANSACTION_CODE,TO_CHAR(TRANSACTION_DATETIME,'DD MON,YYYY') AS TRANS_DT,TOTAL_PAYABLES,CH_PO_NO,CH_PO_ISSUE_DATE,CH_PO_ISSUE_BANK,TRANSACTION_AMOUNT";
$pay_rep_tbl = "SITE_PAYMENT_LOG";

foreach ($obj->View_colmn_By_Cond($pay_rep_tbl, $pay_rep_cols, $pay_rep_cond) as $pay_rep) {
	$i++;
	$total_amount = $pay_rep['TOTAL_PAYABLES'];
	$pay_user_id = $pay_rep['USER_ID'];
	$total_trans_amount = $pay_rep['TRANSACTION_AMOUNT'];
	$grand_total = $grand_total + $total_trans_amount;

	$get_user_type = $obj->View_column_details_By_Cond("SITE_USER_ACL SUA LEFT JOIN SITE_USER_TYPE SUT ON SUA.USER_TYPE_ID = SUT.ID", "SUA.USER_TYPE_ID AS USER_TYPE_ID, SUT.USER_TYPE_NAME AS USER_TYPE_NAME,SUA.NAME AS USER_NAME", "SUA.USER_ID = '$pay_user_id' AND SUT.SHOW=1");
	$user_type_name = $get_user_type['USER_TYPE_NAME'];
	$html .= "<tr>";
	$html .= "<td class='td_left_bottom_border' style='text-align: center;'>$i</td>";
	$html .= "<td class='td_left_bottom_border' style='text-align: left;'>
			<b>User ID: </b>" . $pay_rep['USER_ID'] . "<br/>
			<b>User Name: </b>" . $get_user_type['USER_NAME'] . "<br/>
			<b>Email: </b>" . $pay_rep['EMAIL'] . "<br/>
			<b>Mobile: </b>" . $pay_rep['MOBILE'] . "
          </td>";
	$po_no = !empty($pay_rep['CH_PO_NO']) ? $pay_rep['CH_PO_NO'] : null;
	$po_issue_date = !empty($pay_rep['CH_PO_ISSUE_DATE']) ? $pay_rep['CH_PO_ISSUE_DATE'] : null;
	$po_bank_name = !empty($pay_rep['CH_PO_ISSUE_BANK']) ? $pay_rep['CH_PO_ISSUE_BANK'] : null;
	$invoice_no = !empty($pay_rep['DATA_REQUEST_ID']) ? $pay_rep['DATA_REQUEST_ID'] : null;

	if (is_null($po_no) && is_null($po_issue_date) && is_null($po_bank_name) && is_null($invoice_no)) {
		$html .= "<td>N/A</td>";
	} else {
		$html .= "<td>";
		$html .= "<b> Invoice No: </b>" . ($invoice_no ?? 'N/A') . "<br/>";
		$html .= "<b> Pay Order/Cheque No: </b>" . ($po_no ?? 'N/A') . "<br/>";
		$html .= "<b> Pay Order/Cheque Issue Date: </b>" . ($po_issue_date ?? 'N/A') . "<br/>";
		$html .= "<b> Pay Order/Cheque Bank Name: </b>" . ($po_bank_name ?? 'N/A');
		$html .= "</td>";
	}
	
	$html .= "<td class='td_left_bottom_border' style='text-align: center;'>" . $pay_rep['TRANS_DT'] . "<br> $trans_date</td>";
	$html .= "<td class='td_left_right_bottom_border' style='text-align: right; padding-right: 10px;'>$total_trans_amount</td>";
	$html .= "</tr>";
}
$grand_total_in_word = convert_number2($grand_total);
$html .= "</tbody><tfoot>
<tr>
	<td colspan='4' class='td_left_bottom_border' style='text-align: right; font-weight: bold;'>Total:</td>
	<td class='td_left_right_bottom_border' style='text-align: right; font-weight: bold; padding-right: 10px;'>$grand_total</td>
</tr>
<tr>
	<td colspan='5' style='font-weight: bold; border-left: 1px solid; border-right: 1px solid; border-bottom: 1px solid;'>
		<b>Amount in word:</b> $grand_total_in_word Taka Only</td>
</tr>
</tfoot>
</table>";

$current_date = date('d-m-Y');

$get_signature_image = $obj->View_column_details_By_Cond("SITE_AUTHORITY_SIGN_LIST","NAME,SIGN_IMG","AUTH_TYPE='SA' AND STATUS='A'");
$signature_image = $get_signature_image['SIGN_IMG'];


$html .=" <div class='row-fluid' style='margin-top: 50px;'>
<table width='100%' border='0' style='border-collapse: collapse;'>
    <tr>
        <td align='left' style='width: 33%;'>
            <div style='border-top: 1px solid #000; padding-top: 10px;'></div>
        </td>
        <td align='center' style='width: 33%;'>
            <div style='border-top: 1px solid #000; padding-top: 10px;'></div>
        </td>
        <td align='right' style='width: 30%; padding-right:3%;'>
			<img src='http://hims.bwdb.gov.bd/hydro/asset/custom/upload/documents/img/$signature_image' width='100px' />
            <span>$current_date</span>
            <div style='border-top: 1px solid #000; padding-top: 10px;'>
                System Analyst <br>
                
            </div>
            <div>
                Management & Services Branch <br>
                Hydroinformatics and Flood Forecasting Circle <br>
                BWDB, 72 Green Road, Dhaka.
            </div>
        </td>
    </tr>
    <tr>
        <td align='left' style='padding-top: 50px;'></td>
        <td align='center' style='padding-top: 50px;'></td>
        <td align='right' style='padding-top: 50px;'></td>
    </tr>
</table>
</div>";

$html .= "</body></html>";

$mpdf = new \Mpdf\Mpdf([
	'format' => 'A4-L',
	'margin_left' => 10,
	'margin_right' => 10,
	'margin_top' => 45,
	'margin_bottom' => 4
]);

$header = "<div class='site-header'>
	<img src='../../asset/custom/upload/documents/img/bwdb_report_header.png' width='100%' style='height: 135px;' />
</div>";
$footer = '<div style="text-align: center;">Page: {PAGENO} of {nbpg}</div>';

$mpdf->SetHTMLHeader($header);
$mpdf->SetHTMLFooter($footer);

// Set watermark image and enable it before writing the HTML content
$mpdf->SetWatermarkImage('http://hims.bwdb.gov.bd/hydrology/images/logo.jpg', 0.2, array(80, 80), array(120, 100));
$mpdf->showWatermarkImage = true;

$mpdf->WriteHTML($html);
$mpdf->Output();

