<?php
include("db_conn.php");
$sql_station = "SELECT ST.UPZL_CODE,ST.STATION_ID,ST.STATION_NAME,ST.LATITUDE,ST.LONGITUDE FROM SWL_DATA SW
LEFT JOIN SW_STATION_TBL ST ON SW.STATION_ID = ST.STATION_ID
WHERE ST.TIDAL_STS = 'T'
AND ST.LATITUDE IS NOT NULL 
AND ST.LONGITUDE IS NOT NULL 
AND ST.UPZL_CODE IS NOT NULL
AND ST.STATION_ID LIKE '%SW%'
GROUP BY ST.UPZL_CODE,ST.STATION_ID,ST.STATION_NAME,ST.LATITUDE,ST.LONGITUDE";
$query_station = oci_parse($conn, $sql_station);
oci_execute($query_station);

$info_station = '';

while ($row_station = oci_fetch_assoc($query_station)) {
    $upazilla_code = $row_station['UPZL_CODE'];
    $station_name = $row_station['STATION_NAME'];
    $station = $row_station['STATION_ID'];
    $latitude = $row_station['LATITUDE'];
    $longitude = $row_station['LONGITUDE'];

    $sql_upazilla = "SELECT UPZ.UPZL_NAME,DST.DISTRICT_NAME FROM UPAZILA_TBL UPZ,DISTRICT_TBL DST WHERE 
        UPZ.DST_CODE = DST.DISTRICT_NO AND UPZ.UPZL_CODE = " . $upazilla_code . "";
    $query_upazilla = oci_parse($conn, $sql_upazilla);
    oci_execute($query_upazilla);
    $row_upazilla = oci_fetch_assoc($query_upazilla);

    $sql_wl = "SELECT WL,SWL_DATE FROM SWL_DATA WHERE STATION_ID = '$station' AND ROWNUM<=1 ORDER BY SWL_DATE DESC";
    $query_wl = oci_parse($conn, $sql_wl);
    oci_execute($query_wl);
    $row_wl = oci_fetch_assoc($query_wl);
    $water_level = $row_wl['WL'];
    $date_collected = $row_wl['SWL_DATE'];
    $date_collected = date("j-F-Y", strtotime($date_collected));

    $upazilla = $row_upazilla['UPZL_NAME'];
    $district = $row_upazilla['DISTRICT_NAME'];

    $info_station .= "Station: " . $station_name . "(" . $station . ")<br />District: " . $district . "<br />Upazila: " . $upazilla . "<br />Water Level: " . $water_level . "<br />Date: " . $date_collected . "," . $latitude . "," . $longitude . "#";
}
?>





<section class="contact">
    <div class="container" style="margin-top: -20px;">
        <div class="row">
            <div class="contact_page col-md-12">
                <h2 class="head_heading4"><i class="fas fa-globe"></i> Welcome To BWDB (Processing and Flood Forecasting Circle)</h2>
                <div id="map" style="width: 100%;"></div>
            </div>
            <div class="col-md-4">
                <?php
                $inst_info = $obj->Details_By_Cond("_int_institute_setup", "_type='I'");
                $inst_id = $inst_info['_id'];
                $dataTable = "_int_inst_br_details";

                foreach ($obj->View_All_By_Cond($dataTable, "_pid='$inst_id'") as $value) {
                    extract($value);
                    $div_code = $value['_division'];
                    $dist_code = $value['_district'];
                    $thana_code = $value['_thana'];
                    $division = $obj->Details_By_Cond("_int_country", "_type='dv' and _id='$div_code'");
                    $district = $obj->Details_By_Cond("_int_country", "_type='dc' and _id='$dist_code'");
                    $thana = $obj->Details_By_Cond("_int_country", "_type='th' and _id='$thana_code'");
                ?>
                    <h2 class="head_heading4"><i class="fas fa-map-marker-alt"></i> যোগাযোগের ঠিকানা</h2>
                    <p>
                        <span style="font-weight: bold;"><?php echo $inst_info['_name']; ?><br />
                            <?php echo $value['_address']; ?>, <?php echo $thana['_name']; ?>, <?php echo $district['_name']; ?>-<?php echo $value['_zip_code']; ?><br />
                            <span style="font-weight: bold;">Established Year : </span><?php echo $value['_establish_year']; ?><br />
                            <span style="font-weight: bold;">Contact : </span><?php echo $value['_phone_no']; ?><br />
                            <span style="font-weight: bold;">EIIN : </span><?php echo $value['_code_name']; ?><br />
                        </span>
                    </p>
                <?php } ?>
            </div>
            <div class="col-md-8 feedback-form">
                <h2 class="head_heading4"><i class="fas fa-location-arrow"></i> ফিডব্যাক ফর্ম</h2>
                <form id="feedbackform">
                    <input type="text" id="person_name" class="from-control" placeholder="নাম লিখুন" required>
                    <input type="text" id="subject" class="form-control" placeholder="বিষয় লিখুন" required>
                    <input type="email" id="email" class="form-control" placeholder="আপনার ই-মেইল লিখুন">
                    <textarea rows="2" id="comments" cols="6" name="comments" input type="text" class="form-control" placeholder="মন্তব্য লিখুন"></textarea>
                    <button type="button" class="btn btn-block btn-success" onclick="web_feedback_insert()"><i class="fa fa-location-arrow"></i> প্রেরণ করুন</button>
                </form>
            </div>
        </div>
    </div>
</section>

<link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.css" />
<script src="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.js"></script>


<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script>
    var station = "<?php echo $info_station; ?>";
    var planes = station.split('#');

    var greenIcon = L.icon({
        iconUrl: 'http://www.hydrology.bwdb.gov.bd/map_icons/green.png',
        iconSize: [15, 25], // size of the icon
    });

    var map = L.map('map').setView([23.684994, 90.356331], 7);

    mapLink = '<a href="http://openstreetmap.org">OpenStreetMap</a>';
    L.tileLayer(
        'http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; ' + mapLink + ' Contributors',
            maxZoom: 8,
        }).addTo(map);

    for (var i = 0; i < planes.length; i++) {
        var location_arr = planes[i];
        var location_split = location_arr.split(',');

        L.marker([location_split[1], location_split[2]], {
                icon: greenIcon
            })
            .bindPopup(location_split[0])
            .addTo(map);
    }
</script>







<!-- <script>
    var station = "<?php echo $info_station; ?>";
    var planes = station.split('#');

    var greenIcon = L.icon({
        iconUrl: 'http://www.hydrology.bwdb.gov.bd/map_icons/green.png',
        iconSize: [15, 25], // size of the icon
    });

    var map = L.map('map').setView([23.684994, 90.356331], 7);

    mapLink = '<a href="http://openstreetmap.org">OpenStreetMap</a>';
    L.tileLayer(
        'http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '&copy; ' + mapLink + ' Contributors',
            maxZoom: 8,
        }).addTo(map);

    for (var i = 0; i < planes.length; i++) {
        var location_arr = planes[i];
        var location_split = location_arr.split(',');

        marker = new L.marker([location_split[1], location_split[2]], {
                icon: greenIcon
            })
            .bindPopup(location_split[0])
            .addTo(map);
    }
</script> -->

<!--map link start-->
<!-- <link rel="stylesheet" href="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.css" />
<script src="http://cdn.leafletjs.com/leaflet-0.7.3/leaflet.js"></script> -->
<!-- <script src = "module/morphology/js/leaflet-providers.js"></script> -->
<!--map link end-->