<?php
namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Hidm\HydroDataMaster10;
use App\Models\Hidm\RequestDataDetailsHydro10;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;

class DataController extends Controller
{
    public function dataRequest(Request $request)
    {
        $user = auth()->user();

        $Data = HydroDataMaster10::query()
            ->selectRaw("ID AS REQ_MAS_ID, USER_NAME, MOBILE_NO, EMAIL, CATEGORY, TO_CHAR(REQUEST_DATE,'DD-MON-RR') AS REQUEST_DATE,invoice_no,file_storage_id")
            ->where('PAYMENT_METHOD', ($request->payment_method ?? 1))
            ->whereRaw("TO_DATE(TO_CHAR(REQUEST_DATE,'DD-MON-RR'),'DD-MON-RR') >= TO_DATE('" . now()->subDays(90)->format('d-M-Y') . "','DD-MON-RR')");

        if ($user->user_group_id == 181) {
            $Data->where('PERMISSION_STATUS', 'PENDING');
        } elseif ($user->user_group_id == 302) {
            $Data->where('PERMISSION_STATUS', 'SELECTED');
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        return response()->json(array_merge(['status' => 'success'], ['data_request_info' => $Data->get()->toArray()]));
        // return response()->json(array_merge(['status' => 'success'], $Data->paginate(request()->per_page ?? 10)->toArray()));
    }
    public function requestedUserDetail(Request $request)
    {
        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',

            ], 401);
        }

        $Data = HydroDataMaster10::with('siteUserAcl', 'siteUserAcl.SiteMediaStorage')
            ->where('id', $request->req_mas_id)->get()
            ->map(function ($item) {
                return [
                    'name' => $item->siteUserAcl->name ?? '',
                    'mobile_no' => $item->siteUserAcl->mobile_no ?? '',
                    'email' => $item->siteUserAcl->email ?? '',
                    'residence_address' => $item->siteUserAcl->residence_address ?? '',
                    'user_type_name' => $item->siteUserAcl->UserType->user_type_name ?? '',
                    'invoice_no' => $item->invoice_no ?? '',
                    'grand_total_price' => (string) ($item->grand_total_price ?? 0),
                    'payables_amount' => (string) ($item->payables_amount ?? 0),
                    'discount' => (string) ($item->discount ?? 0),
                    'discount_percent' => (string) ($item->discount > 0 ? numberFormat(($item->discount / $item->grand_total_price) * 100) : 0),
                    'additional_charge' => (string) ($item->additional_charge ?? 0),
                    'additional_charge_percent' => (string) ($item->additional_charge > 0 ? numberFormat(($item->additional_charge / $item->grand_total_price) * 100) : 0),
                    // 'id' => $item->siteUserAcl->SiteMediaStorage->id ??'',
                ];
            });

        if (! isset($Data[0]['invoice_no'])) {
            return response()->json([
                'status' => 'error',
                'message' => 'No Data Found',
            ], 401);
        }

        $req_data_info = $this->requestedDataInfo($Data[0]['invoice_no']);

        return response()->json([
            'status' => 'success',
            'user_info' => $Data ? $Data[0] : [],
            'requested_data_info' => $req_data_info,
        ], 200);
    }

    public function requestedDataInfo($invoice_no)
    {
        $Data = DB::select("SELECT DT_TYP.DATA_TYPE, FREQ.F_NAME, FREQ.DURATION, STAT.STATION_ID, STAT.STATION_NAME, STAT.RIVER_NAME, STAT.UPZL_NAME, STAT.DISTRICT_NAME, REQ_DET.FROM_DATE, REQ_DET.TO_DATE, FREQ.RATE, REQ_DET.TOTAL_AMOUNT
        FROM HYDROLOGY.REQUEST_DATA_DETAILS@HYDRO10 REQ_DET LEFT JOIN HYDROLOGY.DATA_TYPE@HYDRO10 DT_TYP ON REQ_DET.DATA_TYPE_ID=DT_TYP.DID
        LEFT JOIN HYDROLOGY.FREQUENCY@HYDRO10 FREQ ON FREQ.FID=REQ_DET.FREQUENCY_ID
        LEFT JOIN SW_STATION_AUTO_MANUAL STAT ON STAT.STATION_ID=REQ_DET.STATION_ID
        WHERE INVOICE_ID=$invoice_no");
        foreach ($Data as $value) {
            $qunt_type = explode(" ", $value->duration);
            $qunt_type = $qunt_type[count($qunt_type) - 1];
            $qunt = $value->total_amount / $value->rate;
            $value->quantity = "$qunt $qunt_type";
        }
        return $Data;
    }

    public function acceptRejectData(Request $request)
    {
        $user = auth()->user();

        $Data = HydroDataMaster10::with('siteUserAcl')->find($request->req_mas_id);

        $Req_Data = RequestDataDetailsHydro10::where('invoice_id', $Data->invoice_no)->first();

        if ($user->user_group_id == 181) {
            if ($request->status == 'A') {
                $Data->permission_status = 'SELECTED';
                $Data->discount = $request->discount;
                $Data->additional_charge = $request->additional_charge;
                $Data->payables_amount = $request->payables_amount;

                $Req_Data->permission_status = 'Selected';
            } else {
                $Data->permission_status = 'REJECTED';
                $Req_Data->permission_status = 'Rejected';

                $response = Http::get('http://103.141.9.234/hydro/api/mobile_data_api/data_request_notification_email.php', [
                    'invoice_no' => $Data->invoice_no,
                    'status' => 'R',
                    'reason' => $request->rejection_reason,
                ]);

                if ($response->failed()) {
                    return response()->json([
                        'status' => 'failed',
                        'message' => $response->body(),
                    ], 200);
                }
            }

        } elseif ($user->user_group_id == 302) {
            if ($request->status == 'A') {
                $Data->permission_status = 'APPROVED';
                $Data->discount = $request->discount;
                $Data->additional_charge = $request->additional_charge;
                $Data->payables_amount = $request->payables_amount;

                $Req_Data->permission_status = 'Approved';

                $response = Http::get('http://103.141.9.234/hydro/api/mobile_data_api/data_request_notification_email.php', [
                    'invoice_no' => $Data->invoice_no,
                    'status' => 'A',
                    'reason' => $request->rejection_reason,
                ]);

                if ($response->failed()) {
                    return response()->json([
                        'status' => 'failed',
                        'message' => $response->body(),
                    ], 200);
                }

            } else {
                $Data->permission_status = 'REJECTED';
                $Req_Data->permission_status = 'Rejected';

                $response = Http::get('http://103.141.9.234/hydro/api/mobile_data_api/data_request_notification_email.php', [
                    'invoice_no' => $Data->invoice_no,
                    'status' => 'R',
                    'reason' => $request->rejection_reason,
                ]);

                if ($response->failed()) {
                    return response()->json([
                        'status' => 'failed',
                        'message' => $response->body(),
                    ], 200);
                }
            }

        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        $Data->save();
        $Req_Data->save();

        return response()->json([
            'status' => 'success',
            'message' => 'Succesfully updated',
        ], 200);
    }
}
