<?php
namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Hidm\SubdivCodeHydro10;
use App\Models\Hims\RawData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class SerfaceWaterController extends Controller
{
    public function getSubDivision(Request $request)
    {
        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',

            ], 401);
        }

        $sub_division = SubdivCodeHydro10::select('HYDSUBDIVCODE', 'SUBDIVISION_NAME')->orderBy('SUBDIVISION_NAME', 'ASC')->get();
        return response()->json([
            'status' => 'success',
            'sub_division_list' => $sub_division,

        ], 200);
    }

    public function swlDataAvailability(Request $request)
    {
        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',

            ], 401);
        }

        if ($request->to_year - $request->from_year > 2) {
            return response()->json([
                'status' => 'error',
                'message' => 'No more than two year',

            ], 200);
        }
        // dd($request->subdivision);

        $Data = DB::select("SELECT * FROM
        (
        SELECT A.STATION_ID,B.STATION_NAME,TO_CHAR(A.SWL_DATE,'YYYY') as year_val,TO_CHAR(A.SWL_DATE,'MM') as month_val
        FROM  HYDROLOGY.SWL_DATA@HYDRO10 A LEFT JOIN HYDROLOGY.SW_STATION_TBL@HYDRO10 B ON A.STATION_ID=B.STATION_ID
        WHERE B.HYDSUBDIVCODE='$request->subdivision'  AND ',' || B.STATION_TYPE || ',' LIKE '%,' || '1' ||',%' AND TO_CHAR(A.SWL_DATE,'YYYY') BETWEEN '$request->from_year' AND '$request->to_year'
        ORDER BY A.STATION_ID ASC,TO_CHAR(A.SWL_DATE,'YYYY') ASC,TO_CHAR(A.SWL_DATE,'MM') ASC
        ) tt
        pivot (
        count(*)
        for month_val in ('01' AS JAN,'02' AS FEB,'03' AS MAR,'04' AS APR,'05' AS MAY,'06' AS JUN,'07' AS JUL,'08' AS AUG,'09' AS SEP,'10' AS OCT,'11' AS NOV,'12' AS DEC)
        )
        ORDER BY STATION_ID ASC, year_val DESC");

        return response()->json([
            'status' => 'success',
            'swl_data_availability' => $Data,

        ], 200);
    }

    public function swlAvailabilityList()
    {
        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',

            ], 401);
        }

        $swl_list = [
            [
                'name' => 'Water Level',
                'icon' => asset('images/swl/water level.png'),
                'serial_no' => '1',
            ], [
                'name' => 'Rainfall',
                'icon' => asset('images/swl/rainfall.png'),
                'serial_no' => '2',
            ], [
                'name' => 'Evaporation',
                'icon' => asset('images/swl/evaporation.png'),
                'serial_no' => '3',
            ], [
                'name' => 'Observed Discharged',
                'icon' => asset('images/swl/observe discharged.png'),
                'serial_no' => '4',
            ],
            [
                'name' => 'Observed Sediment',
                'icon' => asset('images/swl/observed sediment.png'),
                'serial_no' => '5',
            ], [
                'name' => 'Salinity',
                'icon' => asset('images/swl/salinity.png'),
                'serial_no' => '6',
            ], [
                'name' => 'Tidal Discharge',
                'icon' => asset('images/swl/tidal discharge.png'),
                'serial_no' => '7',
            ], [
                'name' => 'Surface Water Quality',
                'icon' => asset('images/swl/surface water quality.png'),
                'serial_no' => '8',
            ], [
                'name' => 'Climatology',
                'icon' => asset('images/swl/climatology.png'),
                'serial_no' => '9',
            ], [
                'name' => 'Sunshine Data',
                'icon' => asset('images/swl/sunshine data.png'),
                'serial_no' => '10',
            ], [
                'name' => 'MDD',
                'icon' => asset('images/swl/mdd.png'),
                'serial_no' => '11',
            ],
        ];
        return response()->json([
            'status' => 'success',
            'surface_water_list' => $swl_list,

        ], 200);
    }

    public function swInformation(Request $request)
    {
        $user = Auth::user();
        if (! $user) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }
        if (str_contains($user->user_login_id, '@')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        $validation = [
            'station_no' => 'required',
            'from_date' => 'required', 'date',
            'to_date' => 'required', 'date',
        ];
        $Params = [];
        $validator = Validator::make($request->all(), $validation);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => "Validation Error",
                'errors' => $validator->errors(),
            ], 422);
        }
        $Params['station_no'] = $request->station_no;
        $Params['from_date'] = now()->parse("$request->from_date 00:00:00");
        $Params['to_date'] = now()->parse("$request->to_date 23:59:59");

        // dd($Params['from_date'] ,$Params['to_date']);
        // public function getSwAllDataQuery($data,$clientCollectionId, $paginate = false)
        // {
        $Datas = RawData::query()
            ->with('StationOrigin')
            ->whereHas('StationOrigin', function ($query) use ($Params) {
                $query->whereNotNull('sw_station_auto_manual.auto_origin_code');

                if ($Params['station_no']) {
                    $query->where('sw_station_auto_manual.station_id', $Params['station_no']);
                }
            })
            ->where('raw_data.parameter_code', 'STAGE_RT')
            ->orderBy('raw_data.time', 'DESC');

        if ($Params['from_date']) {
            $Datas->where('raw_data.time', '>=', $Params['from_date']);
        }

        if ($Params['to_date']) {
            $Datas->where('raw_data.time', '<=', $Params['to_date']);
        }
        // dd($Datas->first());
        $Station_value = $Datas->get()->map(function ($value) {
            return [
                'datetime' => $value->time->addHour('6')->format('Y-m-d H:i:s'),
                'value' => $value->value,
            ];
        });

        return response()->json([
            'status' => 'success',
            'sw_station' => $Station_value,
        ], 200);

    }
}
