<?php

namespace App\Http\Controllers\V1;

use Illuminate\Http\Request;
use App\Models\Hidm\FfwcStation;
use App\Models\Hidm\HydroStation;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\Hidm\SwStationAutoManual;
use Illuminate\Support\Facades\Validator;

class StationController extends Controller
{
    public function userDetails(Request $request)
    {
        return Auth::user();
    }
    public function stationInfo(Request $request)
    {
        $user = Auth::user();
        if(!$user){
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ],401);
        }
        $user_id=explode("@",  $user->user_login_id);
        $mobile = $user_id[0] ;
        $category = $user_id[1] ;
        // $mobile =isset($user_id[0]) ? $user_id[0] : '';
        // $category = isset( $user_id[1]) ?  $user_id[1] : '';
        if($category == 'hydrosms' && $request->data=='GW'){
            return response()->json([
                'status' => 'success',
                'station_info' => HydroStation::select('old_id as station_name','well_id as keyword')->where('mobile_no',$mobile)->get(),
            ],200);
        }
        elseif($category == 'ffwcsms' && $request->data=='WL'){
            return response()->json([
                'status' => 'success',
                'station_info' => FfwcStation::select('station_name','keyword')->whereIn('station_type',[0,1])->where('mobile_no',$mobile)->get(),
            ],200);
        }
        elseif($category == 'ffwcsms' && $request->data=='RF'){
            return response()->json([
                'status' => 'success',
                'station_info' => FfwcStation::select('station_name','keyword')->whereIn('station_type',[0,2])->where('mobile_no',$mobile)->get(),
            ],200);
        } 
        else{
            return response()->json([
                'status' => 'success',
                'station_info' =>'Do not have access on ',
            ],200);
        }      
    }

    public function swStationInfo(Request $request)
    {
        $user = Auth::user();
        if(!$user){
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ],401);
        }
        if (str_contains($user->user_login_id, '@')) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        $validation = [
            'district_no' => 'required',
           
        ];
        $validator = Validator::make($request->all(), $validation);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => "Validation Error",
                'errors' => $validator->errors(),
            ], 422);
        }

        $data  = SwStationAutoManual::select('station_code', 'STATION_NAME', 'UPZL_NAME')
        ->whereRaw('TRIM(DESCRIPTION) = ?', ['AWLG'])
        ->whereIn('DATA_READ_TYPE', ['AUTO', 'BOTH'])
        ->where('DISTRICT_NO', $request->district_no)
        ->get();
        return response()->json([
            'status' => 'success',
            'sw_station' => $data,
        ], 200);
    }
}
