<?php
namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\CheckUser;
use App\Models\Hidm\FfwcDataLog;
use App\Models\Hidm\FfwcDataTbl;
use App\Models\Hidm\FfwcStation;
use App\Models\Hidm\HydroDataLog;
use App\Models\Hidm\HydroRfData;
use App\Models\Hidm\HydroSwlData;
use App\Models\Hidm\HydroSwStation;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class StationDataStoreController extends Controller
{
    use CheckUser;
    public function hydroDataStore(Request $request)
    {
        if ($this->checkUser("hydrosms") == 0) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized Access',
            ], 401);
        }

        $validation = [
            'keyword' => 'required', 'string',
            'date' => 'required',
            'time' => 'required',
            'value' => 'required',
        ];

        $validator = Validator::make($request->all(), $validation);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => "Validation Error",
                'errors' => $validator->errors(),
            ], 422);
        } else {
            $date = now()->parse($request->date);
            $data = HydroDataLog::where('well_id', $request->keyword)->whereDate('log_date', $date)->first();
            if (! $data) {
                $data = new HydroDataLog();
            }
            $user = Auth::user();
            $data->well_id = $request->keyword;
            $data->log_Date = $date;
            $data->water_lvl = strpos($request->value, '.') === 0 ? "0" . $request->value : $request->value;
            $data->status = 'P';
            $data->flag = 1;
            $data->update_by = $user->user_id;
            $data->update_date = now();
            $flag = $data->save();

            if (! $flag) {
                return response()->json([
                    'status' => 'Error',
                    'message' => 'Something Went wrong',
                ], 200);
            }
            return response()->json([
                'status' => 'success',
                'message' => 'Data Successfully Saved!',
            ], 200);

        }
    }
    public function ffwcDataStore(Request $request): JsonResponse
    {
        if ($this->checkUser("ffwcsms") == 0) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized Access',
            ], 401);
        }

        $validation = [
            'keyword' => 'required', 'string',
            'date' => 'required',
            'value' => 'required',
        ];

        $validator = Validator::make($request->all(), $validation);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => "Validation Error",
                'errors' => $validator->errors(),
            ], 422);
        } else {
            $date = now()->parse($request->date);
            $value = explode(",", $request->value);
            $data_size = count($value);
            $keyword = strtoupper($request->keyword);
            $data = FfwcDataLog::where(DB::raw('UPPER(well_id)'), $keyword)->whereDate('log_date', $date)->firstOrNew();

            $user = Auth::user();

            $FfwcStation = FfwcStation::where(DB::raw('UPPER(keyword)'), $keyword)->where('data', 'WL')->first();
            $FfwcStationRF = FfwcStation::where(DB::raw('UPPER(keyword)'), $keyword)->where('data', 'RF')->first();

            $ffwcDataLogCheck = false;

            if ($data_size == 5) {
                $checkHydroStationExists = HydroSwStation::where('station_id', $FfwcStation->station_code)->whereRaw("(',' || STATION_TYPE || ',') LIKE '%,1,%'")->exists();
                if ($FfwcStation->recorded_high_wl > $value[0] && $FfwcStation->qc_mean_wl <= $value[0]) {
                    $data->hr6 = null;
                    $hr6Date = $date = now()->parse($request->date . ' 06:00:00');
                    $FfwcDataTbl6 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $hr6Date)->firstOrNew();
                    $FfwcDataTbl6->data_value = $value[0];
                    $FfwcDataTbl6->d_type = 'W';
                    $FfwcDataTbl6->station_code = $keyword;
                    $FfwcDataTbl6->m_date = $hr6Date;
                    $FfwcDataTbl6->save();

                    if ($FfwcStation->station_code && $checkHydroStationExists) {
                        HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $hr6Date)->delete();

                        $HydroSwlData6 = new HydroSwlData();
                        $HydroSwlData6->station_id = $FfwcStation->station_code;
                        $HydroSwlData6->data_type = 'R';
                        $HydroSwlData6->swl_date = $hr6Date;
                        $HydroSwlData6->insert_by = $user->user_id;
                        $HydroSwlData6->wl = $value[0];
                        $HydroSwlData6->save();
                    }

                } else if (empty($value[0])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->hr6 = strpos($value[0], '.') === 0 ? "0" . $value[0] : $value[0];
                    $ffwcDataLogCheck = true;
                }

                if ($FfwcStation->recorded_high_wl > $value[1] && $FfwcStation->qc_mean_wl <= $value[1]) {
                    $data->hr9 = null;
                    $hr9Date = $date = now()->parse($request->date . ' 09:00:00');
                    $FfwcDataTbl9 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $hr9Date)->firstOrNew();
                    $FfwcDataTbl9->data_value = $value[1];
                    $FfwcDataTbl9->d_type = 'W';
                    $FfwcDataTbl9->station_code = $keyword;
                    $FfwcDataTbl9->m_date = $hr9Date;
                    $FfwcDataTbl9->save();

                    if ($FfwcStation->station_code && $checkHydroStationExists) {
                        HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $hr9Date)->delete();

                        $HydroSwlData9 = new HydroSwlData();
                        $HydroSwlData9->station_id = $FfwcStation->station_code;
                        $HydroSwlData9->data_type = 'R';
                        $HydroSwlData9->swl_date = $hr9Date;
                        $HydroSwlData9->insert_by = $user->user_id;
                        $HydroSwlData9->insert_dtm = now();
                        $HydroSwlData9->wl = $value[1];
                        $HydroSwlData9->save();
                    }
                } else if (empty($value[1])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->hr9 = strpos($value[1], '.') === 0 ? "0" . $value[1] : $value[1];
                    $ffwcDataLogCheck = true;
                }

                if ($FfwcStation->recorded_high_wl > $value[2] && $FfwcStation->qc_mean_wl <= $value[2]) {
                    $data->hr12 = null;
                    $hr12Date = $date = now()->parse($request->date . ' 12:00:00');
                    $FfwcDataTbl12 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $hr12Date)->firstOrNew();
                    $FfwcDataTbl12->data_value = $value[2];
                    $FfwcDataTbl12->d_type = 'W';
                    $FfwcDataTbl12->station_code = $keyword;
                    $FfwcDataTbl12->m_date = $hr12Date;
                    $FfwcDataTbl12->save();

                    if ($FfwcStation->station_code && $checkHydroStationExists) {
                        HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $hr12Date)->delete();

                        $HydroSwlData12 = new HydroSwlData();
                        $HydroSwlData12->station_id = $FfwcStation->station_code;
                        $HydroSwlData12->data_type = 'R';
                        $HydroSwlData12->swl_date = $hr12Date;
                        $HydroSwlData12->insert_by = $user->user_id;
                        $HydroSwlData12->insert_dtm = now();
                        $HydroSwlData12->wl = $value[2];
                        $HydroSwlData12->save();
                    }
                } else if (empty($value[2])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->hr12 = strpos($value[2], '.') === 0 ? "0" . $value[2] : $value[2];
                    $ffwcDataLogCheck = true;
                }

                if ($FfwcStation->recorded_high_wl > $value[3] && $FfwcStation->qc_mean_wl <= $value[3]) {
                    $data->hr15 = null;
                    $hr15Date = $date = now()->parse($request->date . ' 15:00:00');
                    $FfwcDataTbl15 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $hr15Date)->firstOrNew();
                    $FfwcDataTbl15->data_value = $value[3];
                    $FfwcDataTbl15->d_type = 'W';
                    $FfwcDataTbl15->station_code = $keyword;
                    $FfwcDataTbl15->m_date = $hr15Date;
                    $FfwcDataTbl15->save();

                    if ($FfwcStation->station_code && $checkHydroStationExists) {
                        HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $hr15Date)->delete();

                        $HydroSwlData15 = new HydroSwlData();
                        $HydroSwlData15->station_id = $FfwcStation->station_code;
                        $HydroSwlData15->data_type = 'R';
                        $HydroSwlData15->swl_date = $hr15Date;
                        $HydroSwlData15->insert_by = $user->user_id;
                        $HydroSwlData15->insert_dtm = now();
                        $HydroSwlData15->wl = $value[3];
                        $HydroSwlData15->save();
                    }
                } else if (empty($value[3])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->hr15 = strpos($value[3], '.') === 0 ? "0" . $value[3] : $value[3];
                    $ffwcDataLogCheck = true;
                }

                if ($FfwcStation->recorded_high_wl > $value[4] && $FfwcStation->qc_mean_wl <= $value[4]) {
                    $data->hr18 = null;
                    $hr18Date = $date = now()->parse($request->date . ' 18:00:00');
                    $FfwcDataTbl18 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $hr18Date)->firstOrNew();
                    $FfwcDataTbl18->data_value = $value[4];
                    $FfwcDataTbl18->d_type = 'W';
                    $FfwcDataTbl18->station_code = $keyword;
                    $FfwcDataTbl18->m_date = $hr18Date;
                    $FfwcDataTbl18->save();

                    if ($FfwcStation->station_code && $checkHydroStationExists) {
                        HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $hr18Date)->delete();

                        $HydroSwlData18 = new HydroSwlData();
                        $HydroSwlData18->station_id = $FfwcStation->station_code;
                        $HydroSwlData18->data_type = 'R';
                        $HydroSwlData18->swl_date = $hr18Date;
                        $HydroSwlData18->insert_by = $user->user_id;
                        $HydroSwlData18->insert_dtm = now();
                        $HydroSwlData18->wl = $value[4];
                        $HydroSwlData18->save();
                    }
                } else if (empty($value[4])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->hr18 = strpos($value[4], '.') === 0 ? "0" . $value[4] : $value[4];
                    $ffwcDataLogCheck = true;
                }

            } elseif ($data_size == 1) {
                if ($FfwcStationRF->qc_high_rf > $value[0] && $FfwcStationRF->qc_low_rf <= $value[0]) {
                    $data->rainfall = null;
                    $rf9Date = $date = now()->parse($request->date . ' 09:00:00');
                    $FfwcDataTbl18 = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'R')->where('m_date', $rf9Date)->firstOrNew();
                    $FfwcDataTbl18->data_value = $value[0];
                    $FfwcDataTbl18->d_type = 'R';
                    $FfwcDataTbl18->station_code = $keyword;
                    $FfwcDataTbl18->m_date = $rf9Date;
                    $FfwcDataTbl18->save();

                    $checkHydroStationRainFallExists = HydroSwStation::where('station_id', $FfwcStationRF->station_code)->whereRaw("(',' || STATION_TYPE || ',') LIKE '%,2,%'")->exists();

                    if ($FfwcStationRF->station_code && $checkHydroStationRainFallExists) {
                        HydroRfData::where('station_id', $FfwcStationRF->station_code)->where('rf_date', $rf9Date)->delete();

                        $HydroRfData18 = new HydroRfData();
                        $HydroRfData18->station_id = $FfwcStationRF->station_code;
                        $HydroRfData18->rf_date = $rf9Date;
                        $HydroRfData18->insert_by = $user->user_id;
                        $HydroRfData18->insert_dtm = now();
                        $HydroRfData18->rain_fall = $value[0];
                        $HydroRfData18->save();
                    }
                } else if (empty($value[0])) {
                    $ffwcDataLogCheck = false;
                } else {
                    $data->rainfall = strpos($value[0], '.') === 0 ? "0" . $value[0] : $value[0];
                    $ffwcDataLogCheck = true;
                }
            } else {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Please provide proper data',
                ], 200);
            }

            $data->well_id = $data->well_id ? $data->well_id : $request->keyword;
            $data->log_date = $date;
            $data->status = 'P';
            $data->data_read_type = 'A';
            $data->insert_dtm = now();
            $data->flag = 1;
            $data->update_by = $user->user_id;
            $data->update_date = now();

            if ($ffwcDataLogCheck) {
                $flag = $data->save();
            } else {
                $data->delete();
                $flag = true;
            }

            if (! $flag) {
                return response()->json([
                    'status' => 'Error',
                    'message' => 'Something Went wrong',
                ], 200);
            }

            return response()->json([
                'status' => 'success',
                'message' => 'Data Successfully Saved!',
            ], 200);
        }
    }

    public function ffwcHourlyDataStore(Request $request): JsonResponse
    {
        if ($this->checkUser("ffwcsms") == 0) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized Access',
            ], 401);
        }

        $validation = [
            'keyword' => 'required', 'string',
            'date' => 'required',
            'time' => 'required',
            'value' => 'required',
        ];

        $validator = Validator::make($request->all(), $validation);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => "Validation Error",
                'errors' => $validator->errors(),
            ], 422);
        } else {
            $keyword = strtoupper($request->keyword);
            $user = Auth::user();

            $FfwcStation = FfwcStation::where(DB::raw('UPPER(keyword)'), $keyword)->where('data', 'WL')->first();

            $checkHydroStationExists = HydroSwStation::where('station_id', $FfwcStation->station_code)->whereRaw("(',' || STATION_TYPE || ',') LIKE '%,1,%'")->exists();

            $mDate = now()->parse($request->date . ' ' . $request->time . ':00');
            $FfwcDataTbl = FfwcDataTbl::where(DB::raw('UPPER(station_code)'), $keyword)->where('d_type', 'W')->where('m_date', $mDate)->firstOrNew();
            $FfwcDataTbl->data_value = $request->value;
            $FfwcDataTbl->d_type = 'W';
            $FfwcDataTbl->station_code = $keyword;
            $FfwcDataTbl->m_date = $mDate;
            $FfwcDataTbl->save();

            if ($FfwcStation->station_code &&
                $checkHydroStationExists &&
                in_array($request->time, ['06:00', '09:00', '12:00', '15:00', '18:00'])) {
                HydroSwlData::where('station_id', $FfwcStation->station_code)->where('data_type', 'R')->where('swl_date', $mDate)->delete();

                $HydroSwlData = new HydroSwlData();
                $HydroSwlData->station_id = $FfwcStation->station_code;
                $HydroSwlData->data_type = 'R';
                $HydroSwlData->swl_date = $mDate;
                $HydroSwlData->insert_by = $user->user_id;
                $HydroSwlData->wl = $request->value;
                $HydroSwlData->save();
            }

            return response()->json([
                'status' => 'success',
                'message' => 'Data Successfully Saved!',
            ], 200);
        }
    }
}
