<?php
namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Hidm\UserGroup;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class UserController extends Controller
{
    public function apiLogout(Request $request): JsonResponse
    {
        Auth::user()->tokens()->delete();
        return response()->json([
            'message' => 'Successfully logged out',
        ]);
    }
    public function userDetails(Request $request)
    {
        return Auth::user();
    }

    public function apiLogin(Request $request)
    {
        $validation = [
            'username' => ['required', 'string'],
            'password' => 'required|string',
        ];
        $validator = Validator::make($request->all(), $validation);
        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Invalid Username or Password',
                'errors' => $validator->errors(),
            ], 422);
        }
        $this->ensureIsNotRateLimited();
        $user = User::where('user_login_id', $request->username)->where('user_password', md5($request->password))->first();
        $station_type = [];
        if ($user) {
            if (str_contains($request->username, '@')) {
                Auth::login($user);
                $user_id = explode("@", $request->username);
                $mobile = $user_id[0];
                $category = $user_id[1];
                if ($category == 'hydrosms') {
                    $station_type = [
                        [
                            'type' => 'Water Table',
                            'icon' => asset('images/hidm/water_level.png'),
                            'data' => 'GW',
                        ],
                    ];
                } elseif ($category == 'ffwcsms') {
                    $station_type = [
                        [
                            'type' => 'Water Level',
                            'icon' => asset('images/hidm/water_level.png'),
                            'data' => 'WL',
                        ], [
                            'type' => 'Rainfall',
                            'icon' => asset('images/hidm/rainfall.png'),
                            'data' => 'RF',
                        ],
                    ];
                }
            } else {
                $user_group = UserGroup::select('user_group_id')->where('user_group_id', $user->user_group_id)->pluck('user_group_id')->toArray();

                if (in_array($user_group[0], [181, 302])) {

                    $station_type = [
                        [
                            'type' => 'User Registration',
                            'icon' => asset('images/hidm/user_registration.png'),
                            'data' => 'UR',
                        ], [
                            'type' => 'Data Request',
                            'icon' => asset('images/hidm/data_request.png'),
                            'data' => 'DR',
                        ], [
                            'type' => 'Surface Water',
                            'icon' => asset('images/hidm/surface_water.png'),
                            'data' => 'SW',
                        ], [
                            'type' => 'Ground Water',
                            'icon' => asset('images/hidm/ground_water.png'),
                            'data' => 'GW',
                        ],
                    ];
                    return response()->json([
                        'status' => 'success',
                        'message' => 'Login Successfully',
                        'user_id' => $user->user_id,
                        'name' => $user->user_full_name,
                        'user_group_id' => $user->user_group_id,

                        'authorization' => [
                            'token' => $user->createToken('ApiLoginToken')->plainTextToken,
                            'type' => 'bearer',
                        ],
                        'service_info' => $station_type,
                    ]);
                }
            }
            RateLimiter::clear($this->throttleKey());
            return response()->json([
                'status' => 'success',
                'message' => 'Login Successfully',
                'user_id' => $user->user_id,
                'name' => $user->user_full_name,
                'user_group_id' => $user->user_group_id,

                'authorization' => [
                    'token' => $user->createToken('ApiLoginToken')->plainTextToken,
                    'type' => 'bearer',
                ],
                'service_info' => $station_type,
            ]);
        }
        RateLimiter::hit($this->throttleKey());
        return response()->json([
            'status' => 'error',
            'message' => 'Username or password not valid',
        ], 401);
    }

    public function ensureIsNotRateLimited()
    {
        if (! RateLimiter::tooManyAttempts($this->throttleKey(), 5)) {
            return;
        }
        $seconds = RateLimiter::availableIn($this->throttleKey());
        return response()->json([
            'status' => 'error',
            'message' => 'Too many request',
            'user_login_id' => trans('auth.throttle', [
                'seconds' => $seconds,
                'minutes' => ceil($seconds / 60),
            ]),
        ], 422);
    }
    public function throttleKey()
    {
        return Str::lower(request()->user_login_id) . '|' . request()->ip();
    }
}