<?php
namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Hidm\SiteMediaStorage;
use App\Models\Hidm\SiteUserAcl;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class UserRegistrationController extends Controller
{
    public function userRegistration()
    {
        $user = auth()->user();

        $Data = DB::table('SITE_USER_ACL')
            ->leftJoin('SITE_USER_TYPE', 'SITE_USER_ACL.USER_TYPE_ID', '=', 'SITE_USER_TYPE.ID')
            ->select([
                'USER_ID',
                'SITE_USER_ACL.NAME',
                'EMAIL',
                'MOBILE_NO',
                'USER_TYPE_NAME',
                DB::raw("TO_CHAR(USER_CREATE_TIME, 'DD-MON-YYYY HH:MI:SS AM') AS CREATE_DATETIME"),
                'FILE_STORAGE_ID AS STORAGE_ID',
            ])
            ->orderBy('USER_CREATE_TIME', 'desc');

        if ($user->user_group_id == 181) {
            $Data->where('USER_TYPE', 'public');
        } elseif ($user->user_group_id == 302) {
            $Data->where('USER_TYPE', 'primary');
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        return response()->json(array_merge(['status' => 'success'], ['message' => $Data->get()->toArray()]));
        // return response()->json(array_merge(['status' => 'success'], $Data->paginate(request()->per_page ?? 10)->toArray()));
    }
    public function userDetailsModal(Request $request)
    {
        $validation = [
            'user_id' => ['required'],
        ];

        $validator = Validator::make($request->all(), $validation);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',

            ], 401);
        }

        $user_details = SiteUserAcl::with('UserType')->where('user_id', $request->user_id)->get()
            ->map(function ($item) {
                return [
                    'user_id' => $item->user_id,
                    'name' => $item->name,
                    'email' => $item->email,
                    'mobile_no' => $item->mobile_no,
                    'user_type_name' => $item->UserType->user_type_name,
                    'residence_address' => $item->residence_address,
                    'create_datetime' => Carbon::parse($item->user_create_time)->format('d-M-Y h:i:s A'),
                    'office_phone' => $item->office_phone,
                    'national_id' => $item->national_id,
                    'student_id' => $item->student_id,
                    'user_name' => $item->user_name,
                ];
            });
        return response()->json([
            'status' => 'success',
            'message' => $user_details ? 'Data' : 'Not Available',
            'user_details' => $user_details[0],
        ], 200);
    }
    public function updateUserStatus(Request $request)
    {
        $validation = [
            'user_id' => ['required'],
            'user_status' => ['required'],
            'rejection_reason' => ['nullable', 'string'],
            // 'rejection_reason' => ['required_if:user_status,reject'],
        ];

        $validator = Validator::make($request->all(), $validation);

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'errors' => $validator->errors(),
            ], 422);
        }

        $user = auth()->user();

        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }

        $status = Str::lower($request->user_status);

        if ($status == 'a') {
            if (in_array($user->user_group_id, [181])) {
                $status = 'primary';
            } elseif (in_array($user->user_group_id, [302])) {
                $status = 'private';
            } else {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Unauthorized',
                ], 401);
            }
        } else {
            $status = 'reject';
        }

        $user_details = SiteUserAcl::where('user_id', $request->user_id)->first();

        if ($user_details && ($status == 'reject' || $status == 'private' || $status == 'primary')) {

            $user_details->user_type = $status;
            $user_details->save();

            if ($status == 'reject') {
                $response = Http::get('http://103.141.9.234//hydro/api/mobile_data_api/user_reg_notification_email.php', [
                    'user_id' => $request->user_id,
                    'status' => 'R',
                    'reason' => $request->rejection_reason,
                ]);

                if ($response->failed()) {
                    return response()->json([
                        'status' => 'failed',
                        'message' => $response->body(),
                    ], 200);
                }
            } elseif ($status == 'private') {
                $response = Http::get('http://103.141.9.234//hydro/api/mobile_data_api/user_reg_notification_email.php', [
                    'user_id' => $request->user_id,
                    'status' => 'A',
                    'reason' => $request->rejection_reason,
                ]);

                if ($response->failed()) {
                    return response()->json([
                        'status' => 'failed',
                        'message' => $response->body(),
                    ], 200);
                }
            }

            return response()->json([
                'status' => 'success',
                'message' => 'User succesfully updated',

            ], 200);
        } else {
            return response()->json([
                'status' => 'error',
                'message' => 'Something went wrong',

            ], 403);
        }
    }

    public function viewImageOrPDF(Request $request)
    {
        if (! userGroupCheck()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unauthorized',
            ], 401);
        }
        $data = SiteMediaStorage::where('name', $request->storage_id)->first();

        // return response($data->data, 200)
        //             ->header('Content-Type', $data->mime)
        //             ->header('Content-Disposition', 'inline');

        return response()->json([
            'status' => 'success',
            'type' => $data->mime,
            'data' => base64_encode($data->data),
        ], 200);
    }
}
