<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use App\Models\Hidm\FfwcDataLog;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Resources\Json\JsonResource;

class FfwcStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $date = now()->parse($request->date);
            $value = explode(",", $request->value);

            $data_size = count($value);
            $data = FfwcDataLog::where('well_id', $request->keyword)->whereDate('log_date', $date)->first();
            // $x=Carbon::parse($data->log_date)->format('Y-m-d');

            if (!$data) {
                $data = new FfwcDataLog();
            }
            $user = Auth::user();
            $data->well_id = $request->keyword;
            $data->log_date = $date;
            if ($data_size == 5) {

                $data->hr6 = $value[0];
                $data->hr9 = $value[1];
                $data->hr12 = $value[2];
                $data->hr15 = $value[3];
                $data->hr18 = $value[4];
            } elseif ($data_size == 1) {
                $data->rainfall = $value[0];
            }
            $data->status = 'P';
            $data->flag = 1;
            $data->update_by = $user->user_id;
            $data->update_date = now();
            $flag = $data->save();
            if (!$flag) {
                return [
                    'status' => 'Error',
                    'message' => 'Something Went wrong',
                ];
            }
            return [
                'status' => 'success',
                'message' => 'Data Successfully Saved!',
            ];
        }
    
}
