<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GwStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
                    'station_id' => $this->StationOrigin->identifier,
                    'river_name' => '',
                    'station_name' => $this->StationOrigin->name,
                    'datetime' => $this->time->format('Y-m-d H:i:s'),
                    'danger_level' => '',
                    'longitude' => $this->StationOrigin->longitude,
                    'latitude' => $this->StationOrigin->latitude,
                    'value' => $this->value,
                ];

    }
}
