<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientApiLog extends Model
{
    use HasFactory;
    protected $table = 'api_client_api_logs';
    protected $primaryKey = 'id';
    public $timestamps = true;
    protected $guarded = [];
    public $sequence = null;
    protected $dateFormat = 'Y-M-d H:i:s';
    protected $casts =[
        'request_at' => 'datetime',
        'response_at' => 'datetime',
        'ftp_upload_request_at' => 'datetime',
        'ftp_upload_response_at' => 'datetime',
        'created_at' => 'datetime',
    ];

    public function clientToken()
    {
        return $this->hasOne(ClientToken::class, 'client_id', 'id');
    }
}
