<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClientCollectionParameter extends Model
{
    use HasFactory;

    protected $table = 'api_client_collection_parameters';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function ClientCollection()
    {
        return $this->belongsTo(ClientCollection::class, 'collection_id');
    }

    public function CollectionParameter()
    {
        return $this->belongsTo(CollectionParameter::class, 'collection_parameter_id');
    }

    public function Client()
    {
        return $this->belongsTo(Client::class, 'client_id');
    }
}
