<?php

namespace App\Models;

use App\Models\ClientCollection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Collection extends Model
{
    use HasFactory;
    protected $table = 'api_collections';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function ClientCollection(): HasOne
    {
        return $this->hasOne(ClientCollection::class, 'collection_id');
    }

    public function ClientCollections(): HasMany
    {
        return $this->hasMany(ClientCollections::class, 'collection_id');
    }
}