<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\ClientCollectionParameter;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class CollectionParameter extends Model
{
    use HasFactory;
    protected $table = 'api_collection_parameters';
    protected $primaryKey = 'id';
    protected $guarded = [];

    public function scopeActive($query)
    {
        return $query->where('api_collection_parameters.status', 1);
    }

    public function ClientCollectionParameters()
    {
        return $this->hasMany(ClientCollectionParameter::class, 'collection_parameter_id');
    }

    public function ClientCollectionParameter()
    {
        return $this->hasOne(ClientCollectionParameter::class, 'collection_parameter_id');
    }
}
