<?php

namespace App\Models\Hidm;

use Rishadblack\OracleTableLinker\Traits\HasDbLink;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RequestDataDetailsHydro10 extends Model
{
    use HasDbLink;
    use HasFactory;

    public $timestamps = false;
    // protected $casts = [
    //     'data_type_id' => 'int',
    // ];

    protected $table = 'HYDROLOGY.REQUEST_DATA_DETAILS@HYDRO10';

    protected $guarded = [];

    public function DataTypeHydro10(): BelongsTo
    {
        return $this->belongsTo(DataTypeHydro10::class, 'data_type_id', 'did');
    }

    public function FrequencyHydro10(): BelongsTo
    {
        return $this->belongsTo(FrequencyHydro10::class, 'FREQUENCY_ID', 'did');
    }
}
