<?php

namespace App\Models\Hidm;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SiteUserAcl extends Model
{
    use HasFactory;
   
    public $timestamps = false;
    public $incrementing = false;
    protected $primaryKey = 'user_id';

    protected $guarded = [];
    public function getTable()
    {
        return 'SITE_USER_ACL';
        // return DB::raw('SITE_USER_ACL');
    }

    function UserType() {
        return $this->belongsTo(SiteUserType::class, 'user_type_id', 'id');
    }
    public function SiteMediaStorage(): BelongsTo
    {
        return $this->belongsTo(SiteMediaStorage::class, 'file_storage_id', 'id');
    }
}
