<?php

namespace App\Models\Hims;

use Illuminate\Support\Facades\DB;
use App\Models\Hims\StationDataOrigin;
use Yajra\Oci8\Eloquent\OracleEloquent as Model;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

class DataOrigin extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    public $timestamps = true;
    protected $guarded = [];
    public $sequence = null;

    public function getTable()
    {

        return 'ORACLE_USER.DATA_ORIGIN';
        return DB::raw('ORACLE_USER.DATA_ORIGIN@TSSDB');
    }

    public function StationDataOrigin()
    {
        return $this->belongsTo(StationDataOrigin::class, 'id', 'id');
    }

    public function RawData()
    {
        return $this->belongsTo(RawData::class, 'code', 'origin_code');
    }

    public function Station(): HasOneThrough
    {
        return $this->hasOneThrough(Station::class, StationDataOrigin::class, 'data_origin_id', 'id', 'id', 'station_id');
    }

    public function LatestRawData()
    {
        return $this->hasOne(RawData::class, 'origin_code', 'code')->orderBy('time', 'desc');
    }
}
