<?php

namespace App\Models\Hims;

use App\Models\Hims\Station;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class RawData extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    public $timestamps = true;
    protected $guarded = [];
    public $sequence = null;
    protected $dateFormat = 'Y-M-d H:i:s';
    protected $casts =[
        'time' => 'datetime',
    ];

    public function getTable()
    {
        return 'RAW_DATA';
        // return DB::raw('ORACLE_USER.RAW_DATA@TSSDB');
    }

    public function DataOrigin()
    {
        return $this->belongsTo(DataOrigin::class, 'origin_code', 'code');
    }

    public function StationOrigin()
    {
        return $this->belongsTo(Station::class, 'origin_code', 'auto_origin_code');
    }

    public function latestTime()
    {
        return $this->hasMany(self::class, 'oracle_user.raw_data.origin_code', 'oracle_user.raw_data.origin_code')
            ->select('oracle_user.raw_data.origin_code', DB::raw('MAX(oracle_user.raw_data.time) as max_time'))
            ->groupBy('oracle_user.raw_data.origin_code');
    }
}
