<?php

namespace App\Models\Hims;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

class Station extends Model
{
    use HasFactory;
    protected $connection = 'oracle';
    protected $primaryKey = 'slno';
    public $incrementing = false;
    public $timestamps = false;
    protected $guarded = [];
    public $sequence = null;
    protected $keyType= 'string';

    public function getTable()
    {
        return 'SW_STATION_AUTO_MANUAL';
    }

    public function DataStation(): HasOneThrough
    {
        return $this->hasOneThrough(DataOrigin::class, StationDataOrigin::class, 'station_id', 'id', 'id', 'data_origin_id');
    }

    public function LatestRawData()
    {
        return $this->belongsTo(RawData::class, 'identifier', 'origin_code')->orderBY('time', 'asc')->where('parameter_code', 'GWL_I_1H');
    }
}
