<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\Client;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;

use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;


class ApiInformationTable extends DataTableComponent
{
    use WithSweetAlert;

    // protected $model = Client::class;
    protected $index = 0;
    public function builder(): Builder
    {
        return Client::query(); // Select some things
    }
   
    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown(); 
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);      

    }

    public function filters(): array
    {

        return [

            DateRangeFilter::make('Verified Period'),
            NumberFilter::make('Amount')

            ->config([
                'min' => 0,
                'max' => 10,
            ])

            ->filter(function (Builder $builder, string $value) {

                $builder->where('id', '<', $value);

            }),
            NumberRangeFilter::make('Success Rate')

            ->options(
                [
                    'min' => 0,
                    'max' => 100,
                ]
            )

            ->config([
                'minRange' => 0,
                'maxRange' => 100,
                'suffix' => 'TK',
            ])

            ->filter(function (Builder $builder, array $values) {
                $builder->where('id', '>=', intval($values['min']))
                ->where('id', '<=', intval($values['max']));
            }),

        ];

    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("UUID", "uuid")->sortable()->searchable(),
            Column::make("Name", "name")->sortable()->searchable(),
            Column::make("Office Name", "office_name")->sortable(),
            Column::make("Address", "address")->sortable()->searchable(),
            Column::make("Phone", "name")->sortable()->searchable(),
            Column::make("Email", "email")->sortable()->searchable(),
            Column::make("Start At", "clienttoken.start_at")->format(fn ($value, $row, Column $column)
             => $value ? $value : '')->searchable()->sortable(),
             Column::make("Expire At", "clienttoken.expire_at")->format(fn ($value, $row, Column $column)
             => $value ? $value : '')->searchable()->sortable(),
            Column::make("Is API Access", "is_api_access")->sortable()->searchable(),
            Column::make("Status", "status")->sortable()->searchable(),

        ];
    }
}
