<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\Client;
use App\Models\Collection;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class ApiSetupTable extends DataTableComponent
{
    use WithSweetAlert;

    protected $index = 0;
    public $client_id;

    public function builder(): Builder
    {
        $Data =  Collection::query()
                ->with('ClientCollection', function ($q) {
                    $q->where('client_id', $this->client_id);
                });

        return $Data;
    }

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
        // $this->setAdditionalSelects(['api_collections.collection']);
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);
          $this->setTdAttributes(function (Column $column, $row, $columnIndex, $rowIndex) {
            if ($column->isField('request_url')) {
                return [
                'style' => 'font-size:13px;',
                ];
            }

            return [
                'style' => 'font-size:15px;',
            ];
        });
    }

    // public function filters(): array
    // {

    //     return [

    //         DateRangeFilter::make('Verified Period'),
    //         NumberFilter::make('Amount')

    //         ->config([
    //             'min' => 0,
    //             'max' => 10,
    //         ])

    //         ->filter(function (Builder $builder, string $value) {

    //             $builder->where('id', '<', $value);

    //         }),
    //         NumberRangeFilter::make('Success Rate')

    //         ->options(
    //             [
    //                 'min' => 0,
    //                 'max' => 100,
    //             ]
    //         )

    //         ->config([
    //             'minRange' => 0,
    //             'maxRange' => 100,
    //             'suffix' => 'TK',
    //         ])

    //         ->filter(function (Builder $builder, array $values) {
    //             $builder->where('id', '>=', intval($values['min']))
    //             ->where('id', '<=', intval($values['max']));
    //         }),

    //     ];

    // }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("Title", "title")->sortable()->searchable(),
            Column::make("Description", "des")->sortable()->searchable()->deselected(),
            Column::make("Request Url", "request_url")->format(
                fn ($value, $row, Column $column) => $value ? url($value) : ''
            )->sortable()->searchable(),
            Column::make("Response Type", "response_type")
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_collections_response_type','value' => $value])
            )->sortable()->searchable(),
            Column::make("Request Type", "request_type")
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_collections_request_type','value' => $value])
            )->sortable()->searchable(),
            Column::make("Request Limit", "request_limit")->searchable()->sortable()->deselected(),
            Column::make("Is FTP", "is_ftp")->view('components.status-view')->sortable()->searchable(),
            Column::make('Status', 'status')
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'common','value' => $value])
            )->searchable()->sortable(),
            ButtonGroupColumn::make("Actions")
            ->buttons([
                LinkColumn::make('On')
                    ->title(fn ($row) => 'On')
                    ->location(fn ($row) => 'javascript:void(0)')
                    ->attributes(function ($row) {
                        return [
                            'data-id' => $row->id,
                            'data-status' => 2,
                            'data-listener' => 'OnOff',
                            'class' => "badge me-1 p-2 bg-danger ".($row->ClientCollection && $row->ClientCollection->status == 1 ? "" : "d-none") ,
                            'icon' => 'fa fa-power-off',
                            'title' => "Off",

                        ];
                    }),
                    LinkColumn::make('Off')
                    ->title(fn ($row) => 'Off')
                    ->location(fn ($row) => 'javascript:void(0)')
                    ->attributes(function ($row) {
                        return [
                            'data-id' => $row->id,
                            'data-status' => 1,
                            'data-listener' => 'OnOff',
                            'class' => "badge me-1 p-2 bg-warning ".($row->ClientCollection && $row->ClientCollection->status == 1 ? "d-none" : "") ,
                            'icon' => 'fa fa-power-off',
                            'title' =>  "On",

                        ];
                    }),
                LinkColumn::make('Config')
                    ->title(fn ($row) => 'Config')
                    ->location(fn ($row) => 'javascript:void(0)')
                    ->attributes(function ($row) {
                        return [
                            'data-id' => $row->id,
                            'data-listener' => 'configModal',
                            'class' => 'badge bg-success me-1 p-2' ,
                            'icon' => 'fa fa-cogs',
                            'title' => 'Config',
                            'style' => ($row->ClientCollection && $row->ClientCollection->status == 2 ? 'pointer-events:none; opacity:0.3' : "") ,


                        ];
                    }),
                ]),


        ];
    }
}
