<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\ClientApiLog;
use App\Models\Hims\Station;
use App\Traits\WithSweetAlert;
use App\Models\ClientCollection;
use Livewire\Attributes\Reactive;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\SelectFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class StationTable extends DataTableComponent
{
    use WithSweetAlert;

    #[Reactive]
    public $client_collection_id;

    protected $index = 0;

    public function builder(): Builder
    {
        $Station =  Station::query()->with('ClientCollectionStation'); // Select some things

        return $Station;
    }
    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);

    }

    public array $bulkActions = [
        'accessSelected' => 'Add Access',
        'removeSelected' => 'Remove Access',
    ];

    public function accessSelected()
    {
        $ClientCollection = ClientCollection::find($this->client_collection_id);
        $ClientCollection->Station()->syncWithoutDetaching($this->getSelected());
        $this->alert('success', 'Selected Stations are added to ' . $ClientCollection->Collection->name . ' collection.');
        $this->clearSelected();
    }

    public function removeSelected()
    {
        $ClientCollection = ClientCollection::find($this->client_collection_id);
        $ClientCollection->Station()->detach($this->getSelected());
        $this->alert('success', 'Selected Stations are removed from ' . $ClientCollection->Collection->name . ' collection.');
        $this->clearSelected();
    }

    public function filters(): array
    {
        return [
            SelectFilter::make('Show')
                ->options([
                    '' => 'All',
                    '1' => 'Selected',
                    '2' => 'Not Selected'
                ])
                ->filter(function(Builder $builder,string $value) {
                    if ($value == '1') {
                        $builder->whereHas('ClientCollectionStation', function ($q) {
                            $q->where('api_client_collection_stations.client_collection_id', $this->client_collection_id);
                        });
                    } elseif ($value == '2') {
                        $builder->whereDoesntHave('ClientCollectionStation', function ($q) {
                            $q->where('api_client_collection_stations.client_collection_id', $this->client_collection_id);
                        });
                    }
                }),
        ];
    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn() => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make("Name", "name")->sortable()->searchable(),
            Column::make("Description", "description")->sortable(),
            Column::make("Identifier", "identifier")->sortable()->searchable(),
            Column::make('Status', 'status')
            ->label(
                fn ($row, Column $column) => $row->ClientCollectionStation && $row->ClientCollectionStation->where('client_collection_id',$this->client_collection_id)->count() > 0 ? 'Selected' : 'Not Selected'
            )->sortable(),
        ];
    }
}
