<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_collection_parameters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('collection_id')->nullable();
            $table->string('label')->nullable();
            $table->string('placeholder')->nullable();
            $table->string('name')->nullable();
            $table->string('type')->nullable()->comment('1 = text, 2 = select, 3 = checkbox, 4 = textarea');
            $table->string('is_required')->nullable();
            $table->string('default_value')->nullable();
            $table->json('options')->nullable();
            $table->tinyInteger('status')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_collection_parameters');
    }
};
