<!doctype html>
<html lang="en" dir="ltr">

<head>
    <!-- Meta data -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta
        content="@isset($title)
            {{ $title }} |
        @endisset
        {{ config('app.name') }}"
        name="description">
    <meta content="{{ config('app.name') }}" name="author">
    <meta name="keywords"
        content="@isset($title)
            {{ $title }} |
        @endisset
        {{ config('app.name') }}">

    <!--favicon -->
    <link rel="icon" href="{{ asset('backend/images/brand/favicon.ico') }}" type="image/x-icon">

    <!-- TITLE -->
    <title>
        @isset($title)
            {{ $title }} |
        @endisset
        {{ config('app.name') }}
    </title>

    <!-- BOOTSTRAP CSS -->
    <link id="style" href="{{ asset('backend/plugins/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">

    <!-- STYLES CSS -->
    <link href="{{ asset('backend/css/style.css') }}" rel="stylesheet">

    <!-- PLUGIN CSS -->
    <link href="{{ asset('backend/css/plugin.css') }}" rel="stylesheet">

    <!--- FONT-ICONS CSS -->
    <link href="{{ asset('backend/css/icons.css') }}" rel="stylesheet">

    <!-- Switcher css -->
    <link href="{{ asset('backend/switcher/css/switcher.css') }}" rel="stylesheet" id="switcher-css" type="text/css"
        media="all">
    <link href="{{ asset('backend/switcher/demo.css') }}" rel="stylesheet">
    @livewireStyles
    @livewireScripts
    @vite(['resources/sass/backend.scss', 'resources/js/backend.js'])

</head>

<body class="">

    <!-- BACKGROUND-IMAGE -->
    <div class="login-img">

        <!-- GLOABAL LOADER -->
        <div id="global-loader">
            <img src="{{ asset('backend/images/svgs/loader.svg') }}" class="loader-img" alt="Loader">
        </div>

        <!-- START PAGE -->
        <div class="page">
            <div class="">
                <!-- CONTAINER OPEN -->
                <div class="col col-login mx-auto">
                    <div class="main-logo text-center">
                        
                        {{-- <img src="{{ asset('backend/images/brand/light-logo.png') }}" class="header-brand-img"
                            alt=""> --}}
                        <img src="{{ asset('backend/images/brand/dark-logo.png') }}"
                            class="header-brand-img theme-logos" alt="">
                    </div>
                </div>
                <div class="container-login100">
                    {{ $slot }}
                </div>
                <!-- CONTAINER CLOSED -->
            </div>
        </div>
        <!-- END PAGE -->
    </div>
    <!-- BACKGROUND-IMAGE CLOSED -->

    <!-- JQUERY SCRIPTS -->
    <script src="{{ asset('backend/js/vendors/jquery.min.js') }}"></script>

    <!-- BOOTSTRAP SCRIPTS -->
    <script src="{{ asset('backend/plugins/bootstrap/js/popper.min.js') }}"></script>
    <script src="{{ asset('backend/plugins/bootstrap/js/bootstrap.min.js') }}"></script>

    <!-- CUSTOM-SWICTHER JS -->
    <script src="{{ asset('backend/js/custom-switcher.js') }}"></script>

    <!-- SWITCHER JS -->
    <script src="{{ asset('backend/switcher/js/switcher.js') }}"></script>

    <!-- CUSTOM JS-->
    <script src="{{ asset('backend/js/custom.js') }}"></script>

</body>

</html>
