<div>
    <x-slot name="header"> API Collection List</x-slot>
    <x-layouts.backend.container>
        <x-layouts.backend.card>
            <x-slot name="card_header">
                <x-button.success x-data @click="$dispatch('callEventFunc',{callName:'addApiModal'})" class="btn"
                    icon="fa fa-plus"> Add API
                </x-button.success>
            </x-slot>
            <livewire:himsapi.datatable.collection-list-table />
        </x-layouts.backend.card>
    </x-layouts.backend.container>

    <x-modal id="addApiModal" size="lg" title="{{ $collection_id ? 'Update' : 'Add' }}  Api Information ">

        <div class="row">
            <div class="col-lg-6">
                <x-input.text wire:model="title" label="Title" />
            </div>
            <div class="col-lg-12">
                <x-input.textarea wire:model="des" label="Description" />
            </div>
            <div class="col-lg-12">
                <x-input.text wire:model="request_url" label="Requested Url" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.select wire:model="response_type" label="Response Type" require="true" :options="config('status.api_collections_response_type')" />
            </div>
            <div class="col-lg-6">
                <x-input.select wire:model="request_type" label="Request Type" require="true" :options="config('status.api_collections_request_type')" />
            </div>
            <div class="col-lg-6">
                <x-input.text wire:model="request_limit" label="Request Limit" require="true" />
            </div>
            <div class="col-lg-6">
                <x-input.select wire:model="status" label="Status" require="true" :options="config('status.common')" />
            </div>
            <div class="col-lg-12">
                <x-input.checkbox wire:model.live="is_ftp" label="Is FTP" require="true" />
            </div>
        </div>
        <x-slot name="footer">
            <x-button.success wire:click="ApiStore" wire:target='ApiStore' class="btn-sm" icon="fa fa-check">
                Save
            </x-button.success>
        </x-slot>
    </x-modal>
</div>
