<?php

use App\Http\Controllers\TestController;
use App\Http\Controllers\V1\DataController;
use App\Http\Controllers\V1\DistrictController;
use App\Http\Controllers\V1\SerfaceWaterController;
use App\Http\Controllers\V1\StationController;
use App\Http\Controllers\V1\StationDataFetchController;
use App\Http\Controllers\V1\StationDataStoreController;
use App\Http\Controllers\V1\UserController;
use App\Http\Controllers\V1\UserRegistrationController;
use Illuminate\Support\Facades\Route;

Route::get("test", [TestController::class, 'testget']);

Route::group(['prefix' => 'v1', 'as' => 'v1.'], function () {
    Route::group(['middleware' => 'token_check'], function () {
        Route::post('user/login', [UserController::class, 'apiLogin'])->name('api_login');

        Route::group(['middleware' => 'auth:sanctum'], function () {
            Route::get('user/details', [UserController::class, 'userDetails'])->name('user_details');
            Route::get('user/logout', [UserController::class, 'apiLogout'])->name('api_logout');
            Route::post('get/station-info', [StationController::class, 'stationInfo'])->name('station_info');
            Route::post('get/hydro/station-data', [StationDataFetchController::class, 'hydroDatafetch'])->name('hydro_data_store');
            Route::post('get/ffwc/station-data', [StationDataFetchController::class, 'ffwcDatafetch'])->name('ffwc_data_store');
            Route::post('hydro/station-data/store', [StationDataStoreController::class, 'hydroDataStore'])->name('hydro_data_store');
            Route::post('ffwc/station-data/store', [StationDataStoreController::class, 'ffwcDataStore'])->name('ffwc_data_store');
            Route::post('ffwc/station-hourly-data/store', [StationDataStoreController::class, 'ffwcHourlyDataStore'])->name('ffwc_hourly_data_store');
            Route::post('hydro/station/data/graph', [StationDataFetchController::class, 'hydroGraphData'])->name('hydro_graph_data');
            Route::post('ffwc/station/data/graph', [StationDataFetchController::class, 'ffwcGraphData'])->name('ffwc_graph_data');
            Route::post('hidm/user/registration', [UserRegistrationController::class, 'userRegistration'])->name('user_registration');
            Route::post('user/details/modal', [UserRegistrationController::class, 'userDetailsModal'])->name('user_details');
            Route::post('user/status/update', [UserRegistrationController::class, 'updateUserStatus'])->name('update_user_details');
            Route::post('view/image/PDF', [UserRegistrationController::class, 'viewImageOrPDF'])->name('view_image_or_PDF');
            Route::get('data/request/list', [DataController::class, 'dataRequest'])->name('data_request');
            Route::post('requested/user/data/details', [DataController::class, 'requestedUserDetail'])->name('requested_user_detail');
            Route::post('accept/reject/data', [DataController::class, 'acceptRejectData'])->name('accept_reject_data');
            Route::post('get/sub/division', [SerfaceWaterController::class, 'getSubDivision'])->name('get_sub_division');
            Route::post('swl/data/availability', [SerfaceWaterController::class, 'swlDataAvailability'])->name('swl_data_availability');
            Route::get('swl/availability/list', [SerfaceWaterController::class, 'swlAvailabilityList'])->name('swl_availability_list');
            Route::get('get/district-info', [DistrictController::class, 'districtList'])->name('district_list');
            Route::post('get/sw/auto-manual/station-info', [StationController::class, 'swStationInfo'])->name('sw_station_info');
            Route::post('surface/water/information', [SerfaceWaterController::class, 'swInformation'])->name('sw_information');
        });
    });
});
