<!doctype html>
<html lang="en" dir="ltr">

<head>
    <!-- Meta data -->
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta
        content="<?php if(isset($title)): ?>
            <?php echo e($title); ?> |
        <?php endif; ?>
        <?php echo e(config('app.name')); ?>"
        name="description">
    <meta content="<?php echo e(config('app.name')); ?>" name="author">
    <meta name="keywords"
        content="<?php if(isset($title)): ?>
            <?php echo e($title); ?> |
        <?php endif; ?>
        <?php echo e(config('app.name')); ?>">

    <!--favicon -->
    <link rel="icon" href="<?php echo e(asset('backend/images/brand/favicon.ico')); ?>" type="image/x-icon">

    <!-- TITLE -->
    <title>
        <?php if(isset($title)): ?>
            <?php echo e($title); ?> |
        <?php endif; ?>
        <?php echo e(config('app.name')); ?>

    </title>

    <!-- BOOTSTRAP CSS -->
    <link id="style" href="<?php echo e(asset('backend/plugins/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- STYLES CSS -->
    <link href="<?php echo e(asset('backend/css/style.css')); ?>" rel="stylesheet">

    <!-- PLUGIN CSS -->
    <link href="<?php echo e(asset('backend/css/plugin.css')); ?>" rel="stylesheet">

    <!--- FONT-ICONS CSS -->
    <link href="<?php echo e(asset('backend/css/icons.css')); ?>" rel="stylesheet">

    <!-- Switcher css -->
    <link href="<?php echo e(asset('backend/switcher/css/switcher.css')); ?>" rel="stylesheet" id="switcher-css" type="text/css"
        media="all">
    <link href="<?php echo e(asset('backend/switcher/demo.css')); ?>" rel="stylesheet">
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/sass/backend.scss', 'resources/js/backend.js']); ?>

</head>

<body class="">

    <!-- BACKGROUND-IMAGE -->
    <div class="login-img">

        <!-- GLOABAL LOADER -->
        <div id="global-loader">
            <img src="<?php echo e(asset('backend/images/svgs/loader.svg')); ?>" class="loader-img" alt="Loader">
        </div>

        <!-- START PAGE -->
        <div class="page">
            <div class="">
                <!-- CONTAINER OPEN -->
                <div class="col col-login mx-auto">
                    <div class="main-logo text-center">
                        
                        
                        <img src="<?php echo e(asset('backend/images/brand/dark-logo.png')); ?>"
                            class="header-brand-img theme-logos" alt="">
                    </div>
                </div>
                <div class="container-login100">
                    <?php echo e($slot); ?>

                </div>
                <!-- CONTAINER CLOSED -->
            </div>
        </div>
        <!-- END PAGE -->
    </div>
    <!-- BACKGROUND-IMAGE CLOSED -->

    <!-- JQUERY SCRIPTS -->
    <script src="<?php echo e(asset('backend/js/vendors/jquery.min.js')); ?>"></script>

    <!-- BOOTSTRAP SCRIPTS -->
    <script src="<?php echo e(asset('backend/plugins/bootstrap/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/bootstrap/js/bootstrap.min.js')); ?>"></script>

    <!-- CUSTOM-SWICTHER JS -->
    <script src="<?php echo e(asset('backend/js/custom-switcher.js')); ?>"></script>

    <!-- SWITCHER JS -->
    <script src="<?php echo e(asset('backend/switcher/js/switcher.js')); ?>"></script>

    <!-- CUSTOM JS-->
    <script src="<?php echo e(asset('backend/js/custom.js')); ?>"></script>

</body>

</html>
<?php /**PATH /var/www/html/bwdbhims/mobappsapi/resources/views/layouts/auth.blade.php ENDPATH**/ ?>