<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use App\Models\Hims\RawData;
use App\Models\Hims\Station;
use App\Models\Hims\DataOrigin;
use Illuminate\Console\Command;
use Illuminate\Support\Benchmark;
use Illuminate\Support\Facades\DB;

class ConnectionTesting extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'connect:db';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // $Data = UserVerify::limit(10)->get();
        // $Data = Project::get();


        // dd($Data->toArray());
        $startTime = microtime(true);

        $this->info('Connecting to database...');

        // $Query = RawData::first();
        $Query = Station::where('station_id','like','SW%')->limit(10)->get();

        dd($Query->toArray());

        // $subquery = DB::table('oracle_user.raw_data')
        // $subquery = RawData::query()
        //     ->select('oracle_user.raw_data.origin_code', DB::raw('MAX(oracle_user.raw_data.time) as max_time'))
        //     ->whereHas('DataOrigin', function ($query) {
        //         $query->whereHas('Station', function ($query) {
        //             $query->where('oracle_user.station.identifier', 'like', 'GT87%');
        //         });
        //     })
        //     // ->where('oracle_user.raw_data.origin_code', 'like', 'GT87%')
        //     ->groupBy('oracle_user.raw_data.origin_code')
        //     // ->limit(10);
        // ;

        // dd($subquery->toSql());
        // dd($subquery->get()->toArray());

        // $results = RawData::query()
        //     ->joinSub($subquery, 'latest_times', function ($join) {
        //         $join->on('oracle_user.raw_data.origin_code', '=', 'latest_times.origin_code')
        //             ->on('oracle_user.raw_data.time', '=', 'latest_times.max_time');
        //     })
        //     ->where('oracle_user.raw_data.parameter_code', 'GWL_I_1H')
        //     ->with('DataOrigin', 'DataOrigin.Station');

        // dd($results->toSql());
        // dd($results->get()->toArray());

        // $results = Station::query()
        //     ->with('LatestRawData')
        //     ->where('oracle_user.station.identifier', 'like', 'GT%');


        $results = RawData::query()
            ->with('StationOrigin')
            ->select('ORACLE_USER.RAW_DATA.*')
            ->whereIn(
                DB::raw('(ORACLE_USER.RAW_DATA.ORIGIN_CODE, ORACLE_USER.RAW_DATA.TIME)'),
                function ($subquery) {
                    $subquery->select(DB::raw('ORACLE_USER.RAW_DATA.ORIGIN_CODE, MAX(ORACLE_USER.RAW_DATA.TIME) as max_time'))
                        ->from('ORACLE_USER.RAW_DATA')
                        ->where('ORACLE_USER.RAW_DATA.ORIGIN_CODE', 'like', 'GT%')
                        ->groupBy('ORACLE_USER.RAW_DATA.ORIGIN_CODE');
                }
            )

            ->where('parameter_code', 'GWL_I_1H');


        // ->where('oracle_user.station.identifier', 'like', 'GT8669C03');

        // dd($results->toSql());

        $endTime = microtime(true);

        $elapsedTime = $endTime - $startTime;

        $this->info("Elapsed time: " . number_format($elapsedTime, 4) . " seconds");

        dd($results->limit(100)->get()->toArray(), "Elapsed time: " . number_format($elapsedTime, 4) . " seconds");



        // dd(Haor::limit(2)->get()->toArray());



        // $projects = Project::select('PROJECT_ID', DB::raw('NULL as HAOR_ID'), 'PROJECT_CODE', 'PROJECT_NAME', 'PROJECT_NAME_BN')
        //     ->where('REC_STATUS', 'A')
        //     ->unionAll(
        //         Haor::select(DB::raw('NULL as PROJECT_ID'), 'HAOR_ID', 'HAOR_CODE as PROJECT_CODE', 'HAOR_NAME as PROJECT_NAME', 'HAOR_NAME_BN as PROJECT_NAME_BN')
        //         ->where('REC_STATUS', 'A')
        //     )
        //     ->orderBy('PROJECT_NAME')
        //     ->orderBy('PROJECT_NAME_BN')
        //     ->take(5)
        //     ->get();



        // $projects = DB::table('PI.PROJECT_NAME')
        //     ->select('PROJECT_ID', DB::raw('NULL as HAOR_ID'), 'PROJECT_CODE', 'PROJECT_NAME', 'PROJECT_NAME_BN')
        //     ->where('REC_STATUS', 'A')
        //     ->unionAll(
        //         DB::table('PI.HAOR_NAME')
        //             ->select(DB::raw('NULL as PROJECT_ID'), 'HAOR_ID', 'HAOR_CODE as PROJECT_CODE', 'HAOR_NAME as PROJECT_NAME', 'HAOR_NAME_BN as PROJECT_NAME_BN')
        //             ->where('REC_STATUS', 'A')
        //     )
        //     ->orderBy('PROJECT_NAME')
        //     ->orderBy('PROJECT_NAME_BN')
        //     ->get()->take(5);




        // $projectRecords = DB::table('PI.PROJECT_NAME')
        //     ->select('PROJECT_ID', DB::raw('NULL as HAOR_ID'), 'PROJECT_CODE', 'PROJECT_NAME', 'PROJECT_NAME_BN')
        //     ->where('REC_STATUS', 'A')
        //     ->orderBy('PROJECT_NAME')
        //     ->orderBy('PROJECT_NAME_BN')
        //     ->limit(100)
        //     ->get();

        // $haorRecords = DB::table('PI.HAOR_NAME')
        //     ->select(DB::raw('NULL as PROJECT_ID'), 'HAOR_ID', 'HAOR_CODE as PROJECT_CODE', 'HAOR_NAME as PROJECT_NAME', 'HAOR_NAME_BN as PROJECT_NAME_BN')
        //     ->where('REC_STATUS', 'A')
        //     ->orderBy('PROJECT_NAME')
        //     ->orderBy('PROJECT_NAME_BN')
        //     ->limit(100)
        //     ->get();

        // $combinedRecords = $projectRecords->concat($haorRecords);


        $combinedRecords = DB::table('PI.PROJECT_NAME')
            ->select('PROJECT_ID', DB::raw('NULL as HAOR_ID'), 'PROJECT_CODE', 'PROJECT_NAME', 'PROJECT_NAME_BN')
            ->where('REC_STATUS', 'A')
            ->unionAll(
                DB::table('PI.HAOR_NAME')
                    ->select(DB::raw('NULL as PROJECT_ID'), 'HAOR_ID', 'HAOR_CODE as PROJECT_CODE', 'HAOR_NAME as PROJECT_NAME', 'HAOR_NAME_BN as PROJECT_NAME_BN')
                    ->where('REC_STATUS', 'A')
            )
            ->orderBy('PROJECT_NAME')
            ->orderBy('PROJECT_NAME_BN')
            ->get();



        // Code to be benchmarked goes here

        $endTime = microtime(true);

        $elapsedTime = $endTime - $startTime;

        $this->info("Elapsed time: " . number_format($elapsedTime, 4) . " seconds");




        dd($combinedRecords->toArray(), "Elapsed time: " . number_format($elapsedTime, 4) . " seconds");
        dd($projects->toArray());



        // dd(Office::limit(2)->get()->toArray());
        // dd(SchemeType::limit(2)->get());
        // dd(DB::table('bf.bf_demand_revision')->limit(2)->first());
        // dd(DemandRevision::limit(2)->first());
        // dd(Menu::query()->orderBy('id')->get()->toArray());
        // dd(DB::table('DUAL')->selectRaw('dfn_get_office_level(30)')->first());

        // dd(DB::table('DUAL')->selectOne("select credentials.office($userid,$password)"));
        // dd(DB::selectOne('select credentials.office(750501004,7505) from dual'));





        // $officeId = 691226001;
        // $someValue = 6912;

        // $result = DB::select("SELECT credentials.office(?, ?) FROM dual", [$officeId, $someValue]);
        // dd(DB::selectOne('select credentials.office(750501004,7505) from dual'));



        // $officeId = 50140030;
        // $someValue = 5014;

        // $result = DB::select("SELECT dfn_get_office_level(?) FROM dual", [30]);
        // $result = DB::select("SELECT credentials.verify(?, ?) FROM dual", [$officeId, $someValue]);


        // $result = DB::select("SELECT credentials.office(:officeId, :someValue) FROM dual", [
        //     'officeId' => $officeId,
        //     'someValue' => $someValue,
        // ]);


        // $pdo = DB::getPdo();
        // $x = 750501004;
        // $a = 7505;

        // $stmt = $pdo->prepare("begin :y := credentials.office(:x,:a); end;");
        // $stmt->bindParam(':y', $y);
        // $stmt->bindParam(':x', $x);
        // $stmt->bindParam(':a', $a);
        // $stmt->execute();

        // return $y;
        // dd($y);




        // dd($result);

        // dd(DB::table('dual')->select("credentials.office(691226001, 2379) test")->first());
        // $result = DB::connection('oracle')->select("SELECT credentials.office(750501004, 7505) output FROM dual");
        // $results = DB::select("SELECT TO_NUMBER(credentials.office(750501004, 7505)) AS output FROM dual");






        // $conn = oci_connect('bf', 'te83', 'dcdb.bwdb.gov.bd/tex');

        // dd(callOracleFunc('dpg_credentials.office_name(750501005,7505)'));



        // dd(DB::executeFunction('credentials.office', ['binding_1' => 'hi', 'binding_n' => 'bye'], PDO::PARAM_LOB));



        $this->info('Connected to database...');
    }
}
