<?php

namespace App\Http\Controllers\V1\QueryTraits;

use App\Models\Hims\RawData;
use App\Models\ClientCollection;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\Builder;

trait GwApiQuery
{
    public function getGwAllDataQuery($data, $clientCollectionId, $paginate = false)
    {
    // $Datas = RawData::query()
    //             ->withWhereHas('StationOrigin', function ($query) use ($clientCollectionId) {
    //                 if(ClientCollection::whereNull('is_all_station')->find($clientCollectionId)) {
    //                     $query->whereHas('ClientCollectionStation', function ($query) use ($clientCollectionId) {
    //                         $query->where('api_client_collection_stations.client_collection_id', $clientCollectionId);
    //                     });
    //                 }
    //             })
    //             ->select('ORACLE_USER.RAW_DATA.*')
    //             ->whereIn(
    //                 DB::raw('(ORACLE_USER.RAW_DATA.ORIGIN_CODE, ORACLE_USER.RAW_DATA.TIME)'),
    //                 function ($subquery) use ($data) {
    //                     $subquery->select(DB::raw('ORACLE_USER.RAW_DATA.ORIGIN_CODE, MAX(ORACLE_USER.RAW_DATA.TIME) as max_time'))
    //                         ->from('ORACLE_USER.RAW_DATA')
    //                         ->where('ORACLE_USER.RAW_DATA.ORIGIN_CODE', 'like', 'GT%')
    //                         ->groupBy('ORACLE_USER.RAW_DATA.ORIGIN_CODE');

    //                     if(isset($data['identifier'])) {
    //                         $subquery->where('ORACLE_USER.RAW_DATA.ORIGIN_CODE', $data['identifier']);
    //                     }

    //                     if(isset($data['date']) && $data['date']) {
    //                         $subquery->whereDate('ORACLE_USER.RAW_DATA.TIME', $data['date']);
    //                     } else {
    //                         if(isset($data['from_date']) && $data['from_date']) {
    //                             $subquery->whereDate('ORACLE_USER.RAW_DATA.TIME', '>=', $data['from_date']);
    //                         }

    //                         if(isset($data['to_date']) && $data['to_date']) {
    //                             $subquery->whereDate('ORACLE_USER.RAW_DATA.TIME', '<=', $data['to_date']);
    //                         }
    //                     }
    //                 }
    //             )
    //             ->where('parameter_code', 'GWL_I_1H');

    // dd(RawData::query()->where('parameter_code', 'GWL_I_1H')->first());

    // $Datas = DB::table(DB::raw('ORACLE_USER.RAW_DATA@TSSDB'))->where('oracle_user.raw_data.parameter_code', 'GWL_I_1H');

    // $Datas = RawData::query();

    // $Datas->with('Station', function ($query) use ($clientCollectionId) {
    // if(ClientCollection::whereNull('is_all_station')->find($clientCollectionId)) {
    //     $query->whereHas('ClientCollectionStation', function ($query) use ($clientCollectionId) {
    //         $query->where('api_client_collection_stations.client_collection_id', $clientCollectionId);
    //     });
    // }
    // });

    // $Datas->join(DB::raw('hydrology.gwm_tbl@hydro10'), 'hydrology.gwm_tbl.well_id', '=', 'raw_data.origin_code');

    // if(ClientCollection::whereNull('is_all_station')->find($clientCollectionId)) {
    //     $Datas->whereExists(function (Builder $query) use ($clientCollectionId) {
    //         $query->select(DB::raw(1))
    //             ->from('api_client_collection_stations')
    //             ->whereColumn('api_client_collection_stations.station_id', 'raw_data.origin_code')
    //             ->where('api_client_collection_stations.client_collection_id',$clientCollectionId);
    //     });
    // }

    // $Datas->select('RAW_DATA.*','hydrology.gwm_tbl.*')
    //             ->whereIn(
    //                 DB::raw('(RAW_DATA.ORIGIN_CODE, RAW_DATA.TIME)'),
    //                 function ($subquery) use ($data) {
    //                     $subquery->select(DB::raw('RAW_DATA.ORIGIN_CODE, MAX(RAW_DATA.TIME) as max_time'))
    //                         ->from('RAW_DATA')
    //                         ->where('RAW_DATA.ORIGIN_CODE', 'like', 'GT%')
    //                         ->groupBy('RAW_DATA.ORIGIN_CODE');

    //                     if(isset($data['identifier'])) {
    //                         $subquery->where('RAW_DATA.ORIGIN_CODE', $data['identifier']);
    //                     }

    //                     if(isset($data['date']) && $data['date']) {
    //                         $subquery->whereDate('RAW_DATA.TIME', $data['date']);
    //                     } else {
    //                         if(isset($data['from_date']) && $data['from_date']) {
    //                             $subquery->whereDate('RAW_DATA.TIME', '>=', $data['from_date']);
    //                         }

    //                         if(isset($data['to_date']) && $data['to_date']) {
    //                             $subquery->whereDate('RAW_DATA.TIME', '<=', $data['to_date']);
    //                         }
    //                     }
    //                 }
    //             )
    //             ->where('parameter_code', 'GWL_I_1H');


    // dd($Datas->first());

    $Datas = RawData::query()
                ->with('GtStation')
                ->select('RAW_DATA.*')
                ->whereIn(
                    DB::raw('(RAW_DATA.ORIGIN_CODE, RAW_DATA.TIME)'),
                    function ($subquery) use ($data) {
                        $subquery->select(DB::raw('RAW_DATA.ORIGIN_CODE, MAX(RAW_DATA.TIME) as max_time'))
                            ->from('RAW_DATA')
                            ->where('RAW_DATA.ORIGIN_CODE', 'like', 'GT%')
                            ->groupBy('RAW_DATA.ORIGIN_CODE');

                        if(isset($data['identifier'])) {
                            $subquery->where('RAW_DATA.ORIGIN_CODE', $data['identifier']);
                        }

                        if(isset($data['date']) && $data['date']) {
                            $subquery->whereDate('RAW_DATA.TIME', $data['date']);
                        } else {
                            if(isset($data['from_date']) && $data['from_date']) {
                                $subquery->whereDate('RAW_DATA.TIME', '>=', $data['from_date']);
                            }

                            if(isset($data['to_date']) && $data['to_date']) {
                                $subquery->whereDate('RAW_DATA.TIME', '<=', $data['to_date']);
                            }
                        }
                    }
                )
                ->where('parameter_code', 'GWL_I_1H');

                if(ClientCollection::whereNull('is_all_station')->find($clientCollectionId)) {
                    $Datas->whereHas('ClientCollectionStation', function ($query) use ($clientCollectionId) {
                        $query->where('api_client_collection_stations.client_collection_id', $clientCollectionId);
                    });
                }


        if(isset($data['per_page']) && !$paginate) {
            $Datas->limit($data['per_page']);
        }

        if($paginate && isset($data['per_page'])) {
            return $Datas->paginate($data['per_page']);
        }

        return $Datas->get();
    }
}
