<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class CsManualDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'station_name' => $this->Station->station_name,
            'date' => $this->start_dt->format('d/m/Y'),
            'serial_no' => $this->sl_no,
            'distance' => $this->cs_data_distance,
            'measurement_unit_of_distance' => 'm',
            'rl_value' => $this->rl_val,
            'measurement_unit_of_rl_value' => 'm',
        ];

    }
}
