<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class GwStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        return [
                    'station_id' => $this->origin_code,
                    'river_name' => '',
                    'station_name' => $this->GtStation?->stationname,
                    'datetime' => $this->time->format('Y-m-d H:i:s'),
                    'danger_level' => '',
                    'longitude' => $this->GtStation?->longitude,
                    'latitude' => $this->GtStation?->latitude,
                    'value' => $this->value,
                ];

    }
}
