<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class RainfallAutoDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
                'station_id' => $this->identifier,
                'date' => $this->time->format('Y-m-d H:i:s'),
                "rainfall" => $this->value,
                "measurement_unit" => 'mm',
            ];
    }
}
