<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->Station->station_id,
            'river_name' => $this->Station->river_name,
            'station_name' => $this->Station->station_name,
            'datetime' => $this->time->format('Y-m-d H:i:s'),
            'danger_level' => $this->Station->danger_level,
            'longitude' => $this->Station->longitude,
            'latitude' => $this->Station->latitude,
            'value' => $this->value,
        ];
    }
}