<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SwlManualDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {

        if ($this->Station->tidal_sts == 'NT') {
            return [
                'station_id' => $this->station_id,
                'station_name' => $this->Station->station_name,
                'date' => $this->swl_date->format('d/m/Y'),
                'value' => $this->value,
                'measurement_unit' => 'mMSL',
            ];
        } else {
            return [
                'station_id' => $this->station_id,
                'station_name' => $this->Station->station_name,
                'date' => $this->swl_date->format('d/m/Y'),
                'wl_high_value' => $this->value_max,
                'wl_low_value' => $this->value_min,
                'measurement_unit' => 'mMSL',
            ];
        }

    }

    public function getDataType($type)
    {
        if ($type == 'R') {
            return 'Reguler';
        } elseif ($type == 'H') {
            return 'High';
        } elseif ($type == 'L') {
            return 'Low';
        } else {
            return 'M';
        }
    }
}
