<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WaterlevelDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     *
     */

    public function toArray(Request $request): array
    {
        return [
            'station_id' => request()->station_id ?? $this->station_code,
            'last_update' => $this->m_date->format('Y-m-d H:i:s'),
            'wl_date' => $this->m_date->format('Y-m-d H:i:s'),
            'water_level' => str_replace(' ', '', $this->data_value),
            'unit' => 'm',
        ];
    }
}
