<?php
namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WaterlevelStationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     *
     */

    public function toArray(Request $request): array
    {
        return [
            'id_db' => $this->ffwc_sl_no,
            'station_id' => $this->station_id,
            "sms_id" => $this->ffwc_keyword,
            'name' => $this->ffwc_station_name,
            'river' => $this->river_name,
            'basin' => $this->ffwc_basin,
            'division' => $this->ffwc_sub_measure_div,
            'district' => $this->district_name,
            'upazilla' => $this->upzl_name,
            'union' => $this->union_name,
            'danger_level' => $this->ffwc_danger_level,
            'river_highest_water_level' => $this->ffwc_recorded_high_wl,
            'lat' => $this->latitude,
            'long' => $this->longitude,
            // 'forecast observation' => '',
            // 'diterministic forecast station' => '',
            'medium_range_station' => '',
            'status' => 1,
            'measurement_unit' => 'm',
        ];
    }
}
