<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class WeatherAutoDataResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'station_id' => $this->station_id,
            'date' => $this->bd_time->format('Y-m-d H:i:s'),
            "air_temperature" => $this->air_temperature,
            "air_temperature_measurement_unit" => 'Degree Celcius',
            "humidity" => $this->humidity,
            "humidity_measurement_unit" => 'Percentage',
            "wind_speed" => $this->wind_speed,
            "wind_speed_measurement_unit" => 'Metre per Second',
            "wind_direction" => $this->wind_direction,
            "wind_direction_measurement_unit" => 'Degree',
            "air_pressures" => $this->air_pressures,
            "air_pressures_measurement_unit" => 'Hectopascal',
            "solar_radiation" => $this->solar_radiation,
            "solar_radiation_measurement_unit" => 'Watt per square meter',
            "evaporation" => $this->evaporation,
            "measurement_unit" => 'mm',
        ];
    }
}
