<?php
namespace App\Models\Hims;

use App\Models\ClientCollection;
use App\Models\ClientCollectionStation;
use App\Models\Hims\DataOrigin;
use App\Models\Hims\RawData;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;
use Rishadblack\OracleTableLinker\Traits\HasDbLink;
use Yajra\Oci8\Eloquent\OracleEloquent as Model;

// use Illuminate\Database\Eloquent\Model;

class FfwcData extends Model
{
    use HasFactory, HasDbLink;

    protected $connection = 'oracle';
    protected $primaryKey = 'pk_id';
    public $incrementing  = false;
    public $timestamps    = false;
    protected $guarded    = [];
    public $sequence      = null;
    protected $keyType    = 'string';
    protected $dateFormat = 'd-M-Y';
    protected $table      = 'ffwc.data_tbl';
    protected $casts      = [
        'm_date' => 'datetime',
    ];

    public function DataStation(): HasOneThrough
    {
        return $this->hasOneThrough(DataOrigin::class, StationDataOrigin::class, 'station_id', 'id', 'id', 'data_origin_id');
    }

    public function LatestRawData()
    {
        return $this->belongsTo(RawData::class, 'identifier', 'origin_code')->orderBY('time', 'asc')->where('parameter_code', 'GWL_I_1H');
    }

    public function ClientCollectionStation()
    {
        return $this->hasMany(ClientCollectionStation::class, 'station_id', 'station_id');
    }

    public function ClientCollection(): BelongsToMany
    {
        return $this->belongsToMany(ClientCollection::class, ClientCollectionStation::class, 'station_id', 'client_collection_id', );
    }

    public function ffwcStation()
    {
        return $this->belongsTo(FfwcStation::class, 'station_code', 'station_code');
    }

    public function ffwcStationKeyword()
    {
        return $this->belongsTo(FfwcStation::class, 'station_code', 'ffwc_keyword');
    }
}
