<?php

namespace App\Models\Hims;

use App\Models\ClientCollection;
use App\Models\ClientCollectionStation;
use App\Models\Hims\Station;
use App\Models\Hims\SwStationManual;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Rishadblack\OracleTableLinker\Traits\HasDbLink;
use Yajra\Oci8\Eloquent\OracleEloquent as Model;

// use Illuminate\Database\Eloquent\Model;

class HydrologyObsSediment extends Model
{
    use HasFactory;
    use HasDbLink;

    // protected static $firstCall;

    protected $connection = 'oracle';
    protected $primaryKey = 'station_id';
    public $incrementing = false;
    public $timestamps = false;
    protected $guarded = [];
    public $sequence = null;
    protected $keyType = 'string';
    protected $table = 'HYDROLOGY.OBS_SEDIMENT@HYDRO10';

    protected $casts = [
        'sed_dt' => 'datetime',
        'updt_dtm' => 'datetime',
        'insert_dtm' => 'datetime',
    ];

    public function Station(): BelongsTo
    {
        return $this->belongsTo(Station::class, 'station_id', 'station_id');
    }

    public function SwStationManual(): BelongsTo
    {
        return $this->belongsTo(SwStationManual::class, 'station_id', 'station_id');
    }

    public function SwStationManualJoin(): HasOne
    {
        return $this->hasOne(SwStationManual::class, 'station_id', 'station_id');
    }

    public function ClientCollectionStation(): HasMany
    {
        return $this->hasMany(ClientCollectionStation::class, 'station_id', 'station_id');
    }

    public function ClientCollection(): BelongsToMany
    {
        return $this->belongsToMany(ClientCollection::class, ClientCollectionStation::class, 'station_id', 'client_collection_id');
    }
}
