<?php

namespace App\Models\Hims;

use App\Models\Hims\RawData;
use App\Models\Hims\DataOrigin;
use App\Models\ClientCollection;
use Illuminate\Support\Facades\DB;
use App\Models\ClientCollectionStation;
use Yajra\Oci8\Eloquent\OracleEloquent as Model;
use Rishadblack\OracleTableLinker\Traits\HasDbLink;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

// use Illuminate\Database\Eloquent\Model;

class SwStationManual extends Model
{
    use HasFactory;
    use HasDbLink;

    // protected static $firstCall;

    protected $connection = 'oracle';
    protected $primaryKey = 'slno';
    public $incrementing = false;
    public $timestamps = false;
    protected $guarded = [];
    public $sequence = null;
    protected $keyType = 'string';
    protected $table = 'HYDROLOGY.SW_STATION_TBL@HYDRO10';

    protected $casts = [
       'sob_date' => 'datetime',
    ];

    public function DataStation(): HasOneThrough
    {
        return $this->hasOneThrough(DataOrigin::class, StationDataOrigin::class, 'station_id', 'id', 'id', 'data_origin_id');
    }

    public function LatestRawData()
    {
        return $this->belongsTo(RawData::class, 'identifier', 'origin_code')->orderBY('time', 'asc')->where('parameter_code', 'GWL_I_1H');
    }

    public function ClientCollectionStation()
    {
        return $this->hasMany(ClientCollectionStation::class, 'station_id', 'station_id');
    }

    public function ClientCollection(): BelongsToMany
    {
        return $this->belongsToMany(ClientCollection::class, ClientCollectionStation::class, 'station_id', 'client_collection_id');
    }
}
