<?php

namespace App\Pages\Himsapi;

use Livewire\Component;
use App\Models\ClientToken;
use App\Pages\Himsapi\Client;
use App\Traits\WithSweetAlert;

class BwdbFileShare extends Component
{
    use WithSweetAlert;
    public $id;
    public $uuid;
    public $name;
    public $office_name;
    public $address;
    public $phone;
    public $email;
    public $status;
    public $token;
    public $client_token = 0;
    public $start_at;
    public $expire_at;

    protected $listeners = [
        'addClientModal',
        'clientDelete',
    ];

    public function addClientModal($data = [])
    {
        $this->reset();
        $this->dispatch('typeahead_reset');

        if (isset($data['id'])) {
            $this->clientEdit($data['id']);
        }

        $this->dispatch('modalOpen', 'addClientModal');
    }
    public function clientInfoStore()
    {
        $validation = [
            'name' => ['required', 'string'],
            'office_name' => ['required', 'string'],
            'address' => ['nullable', 'string'],
            'phone' => ['required', 'numeric', 'digits:11'],
            'email' => ['required', 'email'],
        ];

        $this->validate($validation);

        $Client = Client::findOrNew($this->id);
        $Client->uuid = $this->uuid;
        $Client->name = $this->name;
        $Client->office_name = $this->office_name;
        $Client->address = $this->address;
        $Client->phone = $this->phone;
        $Client->email = $this->email;
        $Client->save();

        $ApiToken = ClientToken::where('client_id', $Client->id)->firstOrNew(['client_id' => $Client->id]);
        $ApiToken->client_id = $Client->id;
        $ApiToken->token = $ApiToken->token ?? bin2hex(random_bytes(16));
        $ApiToken->start_at = $ApiToken->start_at ?? now();
        $ApiToken->save();

        $this->reset();
        $this->dispatch('refreshDatatable');
        $this->alert('success', 'client successfully '.($this->id ? 'updated':'created'));

    }

    public function clientEdit($id)
    {
        $Client = Client::find($id);

        if (!$Client) {
            $this->alert('error', "Client Not Find");
            return;
        }
        $this->id = $id;
        $this->uuid = $Client->uuid;
        $this->name = $Client->name;
        $this->office_name = $Client->office_name;
        $this->email = $Client->email;
        $this->address = $Client->address;
        $this->phone = $Client->phone;
        $this->email = $Client->email;
    }

    public function clientDelete($data = [])
    {
        $data = $this->alertConfirm($data);

        if (isset($data['id'])) {
            Client::find($data['id'])->delete();

            $this->emit('refreshDatatable');
            $this->alert('success', 'client successfully deleted');
        }
    }


    public function render()
    {
        return view('pages.himsapi.bwdb-file-share');
    }
}
