<?php

namespace App\Pages\Himsapi\Datatable;

use App\Models\Client;
use App\Models\Collection;
use App\Models\CollectionParameter;
use App\Traits\WithSweetAlert;
use Illuminate\Database\Eloquent\Builder;

use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\DataTableComponent;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberFilter;
use Rappasoft\LaravelLivewireTables\Views\Filters\DateRangeFilter;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;
use Rappasoft\LaravelLivewireTables\Views\Filters\NumberRangeFilter;

class CollectionParameterListTable extends DataTableComponent
{
    use WithSweetAlert;

    public $collection_id;
    protected $index = 0;

    public function builder(): Builder
    {
        return CollectionParameter::query()->where('collection_id',$this->collection_id); // Select some things
    }


    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setSearchThrottle(1000);
        $this->setFilterLayoutSlideDown();
        $this->setTheadAttributes([
            'default' => true,
            'class' => '',
            'style' => 'background-color:#c1dfff;',
          ]);
    }

    public function filters(): array
    {

        return [

            DateRangeFilter::make('Verified Period'),
            NumberFilter::make('Amount')

                ->config([
                    'min' => 0,
                    'max' => 10,
                ])

                ->filter(function (Builder $builder, string $value) {

                    $builder->where('id', '<', $value);
                }),
            NumberRangeFilter::make('Success Rate')

                ->options(
                    [
                        'min' => 0,
                        'max' => 100,
                    ]
                )

                ->config([
                    'minRange' => 0,
                    'maxRange' => 100,
                    'suffix' => 'TK',
                ])

                ->filter(function (Builder $builder, array $values) {
                    $builder->where('id', '>=', intval($values['min']))
                        ->where('id', '<=', intval($values['max']));
                }),

        ];
    }

    public function columns(): array
    {
        return [
            Column::make("Id", "id")->format(fn () => ++$this->index +  ($this->getPage() - 1) * $this->perPage),
            Column::make('Type', 'type')
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'api_collection_parameters_type','value' => $value])
            )->searchable()->sortable(),
            Column::make("Label", "label")->sortable()->searchable(),
            Column::make("Name", "name")->sortable()->searchable(),
            Column::make("Is Requried", "is_required")->view('components.status-view')->sortable()->searchable(),
            Column::make('Status', 'status')
            ->format(
                fn ($value, $row, Column $column) => view('components.option-view', ['status' => 'common','value' => $value])
            )->searchable()->sortable(),
            ButtonGroupColumn::make("Actions")
            ->buttons([
                LinkColumn::make('Edit')
                    ->title(fn ($row) => 'Edit')
                    ->location(fn ($row) => 'javascript:void(0)')
                    ->attributes(function ($row) {
                        return [
                            'data-id' => $row->id,
                            'data-listener' => 'addParameterModal',
                            'class' => 'badge bg-success me-1 p-2 ',
                            'icon' => 'fa fa-edit',
                            'title' => 'Edit',

                        ];
                    }),
                LinkColumn::make(' Delete')
                    ->title(fn ($row) => 'Delete')
                    ->location(fn ($row) => 'javascript:void(0)')
                    ->attributes(function ($row) {
                        return [
                            'data-id' => $row->id,
                            'data-listener' => 'parameterDelete',
                            'class' => 'badge bg-danger me-1 p-2 ',
                            'icon' => 'fa fa-trash',
                            'title' => 'Delete',

                        ];
                    }),

            ]),


        ];
    }
}
