<?php

namespace App\Pages\Setting\Datatable;

use Illuminate\Support\Str;
use Spatie\Permission\Models\Role;
use App\Http\Common\DatatableComponent;
use App\Models\Setting\Menu;
use Illuminate\Database\Eloquent\Builder;
use Rappasoft\LaravelLivewireTables\Views\Column;
use Rappasoft\LaravelLivewireTables\Views\Columns\LinkColumn;
use Rappasoft\LaravelLivewireTables\Views\Columns\ButtonGroupColumn;

class MenuTable extends DataTableComponent
{
    protected $index = 0;

    public function configure(): void
    {
        $this->setPrimaryKey('id');
        $this->setOfflineIndicatorEnabled();

        $this->setPerPageAccepted(perPageRows());
        $this->setTableAttributes([
            'class' => 'table-sm',
          ]);
    }

    public function columns(): array
    {
        return [
            Column::make(__('default.sn'), 'id')->format(fn() => ++$this->index +  ($this->page - 1) * $this->perPage),
            Column::make(__('default.name'), 'name')->format(
                fn($value, $row, Column $column) => $value ? Str::title($value) : ''
            )->searchable()->sortable(),
            Column::make(__('default.name') . " " . __('default.bangla'), 'name_bn')->format(
                fn($value, $row, Column $column) => $value ? Str::title($value) : ''
            )->searchable()->sortable(),
            Column::make(__('default.date'), 'created_at')->format(
                fn($value, $row, Column $column) => $value ? $value->format(getTimeFormat()) : ''
            )->searchable()->sortable(),
            ButtonGroupColumn::make(__('default.action'))
                // ->attributes(function ($row) {
                //     return [
                //         'class' => 'text-center',
                //     ];
                // })
                ->buttons([
                    LinkColumn::make('Edit')
                        ->title(fn($row) => __('default.edit'))
                        ->location(fn($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'menuModal',
                                'class' => 'text-success me-1' ,
                                'icon' => 'fa fa-edit',
                                'data-permission' => 'menu.update',
                            ];
                        }),
                    LinkColumn::make(' Delete')
                        ->title(fn($row) => __('default.delete'))
                        ->location(fn($row) => 'javascript:void(0)')
                        ->attributes(function ($row) {
                            return [
                                'data-id' => $row->id,
                                'data-listener' => 'menuDelete',
                                'class' => 'text-danger me-1' ,
                                'icon' => 'fa fa-trash',
                                'data-permission' => 'menu.delete',
                            ];
                        }),
                ])->hideIf(!ucan('menu.update|menu.delete')),
        ];
    }

    public function builder(): Builder
    {
        return Menu::query(); // Select some things
    }
}
