<?php

namespace App\Pages\Setting;

use App\Models\Setting\Menu;
use App\Http\Common\Component;
use App\Models\Setting\RouteName;

class MenuList extends Component
{
    public $menu_id;
    public $name;
    public $name_bn;
    public $parent_id;
    public $route_name;
    public $icon;
    public $status;

    protected $listeners = [
        'menuModal',
        'menuDelete',
    ];

    public function menuModal($data = [])
    {
        $this->reset();
        $this->dispatchBrowserEvent('typeahead_reset');
        if (isset($data['id'])) {
            $this->menuEdit($data['id']);
        }

        $this->dispatchBrowserEvent('modalOpen', 'menuModal');
    }

    public function menuEdit($id)
    {
        $this->menu_id = $id;
        $Menu = Menu::find($id);

        if (!$Menu) {
            $this->alert('error', 'Menu not found!');
            return;
        }
        $this->name = $Menu->name;
        $this->name_bn = $Menu->name_bn;
        $this->parent_id = $Menu->parent_id;
        $this->route_name = $Menu->route_name;
        $this->icon = $Menu->icon;
        $this->status = $Menu->status;
        $this->dispatchBrowserEvent('typeahead_update');
    }

    public function userStore()
    {

        $validation = [
                    'name' => ['required', 'string', 'max:255'],
                    'route_name' => ['required'],
                    'status' => ['required'],
                ];

        $this->validate($validation);

        if ($this->menu_id) {
            $Menu = Menu::find($this->menu_id);
        } else {
            $Menu = new Menu();
            $Menu->id = Menu::count() + 1;
        }
        $Menu->name = $this->name;
        $Menu->name_bn = $this->name_bn;
        $Menu->parent_id = $this->parent_id;
        $Menu->route_name = $this->route_name;
        $Menu->permission_name = RouteName::whereName($this->route_name)->first()->permission_name;
        $Menu->icon = $this->icon;
        $Menu->status = $this->status;
        $Menu->save();

        $this->emit('refreshDatatable');
        $this->dispatchBrowserEvent('modalClose', 'menuModal');
        $this->alert('success', __('default.menu') . " " . __('default.list') . " " . __('default.succesfully') . " " . ($this->menu_id ? __('default.updated') : __('default.created')));
    }

    public function menuDelete($data = [])
    {
        $data = $this->alertConfirm($data);

        if (isset($data['id'])) {
            $Menu = Menu::find($data['id']);

            if (!$Menu) {
                $this->alert('error', 'Menu not found!');
                return;
            }

            $Menu->delete();

            $this->emit('refreshDatatable');
            $this->alert('success', __('setting.menu') . " " . __('default.list') . " " . __('default.succesfully') . " " . __('default.deleted'));
        }
    }

    public function render()
    {
        return view('pages.setting.menu-list', [
            'route_names' => RouteName::active()->get(),
            'menus' => Menu::active()->rootMenu()->get(),
        ]);
    }
}
