<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_client_collection_parameters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('collection_parameter_id')->nullable();
            $table->foreignId('collection_id')->nullable();
            $table->foreignId('client_id')->nullable();
            $table->text('value')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_client_collection_parameters');
    }
};
